% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{remove_variables}
\alias{remove_variables}
\title{Remove variables based on expression profiles across samples.}
\usage{
remove_variables(sce = NULL, min_nsamples = 0)
}
\arguments{
\item{sce}{A SingleCellExperiment object.}

\item{min_nsamples}{An integer. This function removes variables for which
the numbers of non-zero expressing samples are less than this value.}
}
\value{
A SingleCellExperiment object.
}
\description{
This function removes low expressed variable data.
}
\examples{
data(pbmc_eg)
pbmc <- add_metadata(sce = pbmc_eg, mitochondria_symbol = "^MT-")
pbmc <- remove_variables(sce = pbmc, min_nsamples = 10)

}
