% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_signs.R
\name{cluster_genesets}
\alias{cluster_genesets}
\title{Cluster each functional gene set into three groups.}
\usage{
cluster_genesets(sce = NULL, cormat = NULL, th_posi = NULL, th_nega = NULL)
}
\arguments{
\item{sce}{A SingleCellExperiment object.}

\item{cormat}{A correlation matrix of gene expressions.}

\item{th_posi}{A threshold of positive correlation coefficient.}

\item{th_nega}{A threshold of negative correlation coefficient.}
}
\value{
A SingleCellExperiment object.
}
\description{
This function clusters each functional gene set into strongly, variably, and
  weakly correlated gene sets.
}
\examples{
data(pbmc_eg)
data(human_GO_eg)
mat <- t(as.matrix(SummarizedExperiment::assay(pbmc_eg, "centered")))
pbmc_cormat <- cor(mat, method = "spearman")
pbmcs <- list(GO = pbmc_eg)
S4Vectors::metadata(pbmcs$GO) <- list(sign = human_GO_eg[["BP"]])
pbmcs$GO <- remove_signs(sce = pbmcs$GO, min_ngenes = 2, max_ngenes = 1000)
pbmcs$GO <- cluster_genesets(sce = pbmcs$GO, cormat = pbmc_cormat,
                             th_posi = 0.24, th_nega = -0.20)
# The results are stored in `metadata(pbmcs$GO)$sign`.

}
