% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getWorkflowConfig.R
\name{getWorkflowConfig}
\alias{getWorkflowConfig}
\title{Check the workflow configuration}
\usage{
getWorkflowConfig(workspaceName, workflowName = NULL)
}
\arguments{
\item{workspaceName}{Name of the workspace}

\item{workflowName}{Name of the workflow to run. If a single workflow is
available under the specified workspace, this function will check the input
of that workflow under the default (\code{NULL}). If there are multiple
workflows available, you should specify the workflow.}
}
\value{
A data.frame for the inputs defined in a workflow configuration.
}
\description{
Check the workflow configuration
}
\examples{
library(AnVILBase)
if (has_avworkspace(strict = TRUE, platform = AnVILGCP::gcp())) {
config <- getWorkflowConfig(workspaceName = "Bioconductor-Workflow-DESeq2")
config
}

}
