% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AnVILBase-methods.R
\name{AnVILBase-methods}
\alias{AnVILBase-methods}
\alias{avcopy,missing-method}
\alias{avcopy,ANY-method}
\alias{avlist,missing-method}
\alias{avlist,ANY-method}
\alias{avremove,missing-method}
\alias{avremove,ANY-method}
\alias{avbackup,missing-method}
\alias{avbackup,ANY-method}
\alias{avrestore,missing-method}
\alias{avrestore,ANY-method}
\alias{avstorage,missing-method}
\alias{avstorage,ANY-method}
\title{The AnVILBase methods for 'missing' and 'ANY' signatures}
\usage{
\S4method{avcopy}{missing}(..., platform)

\S4method{avcopy}{ANY}(..., platform)

\S4method{avlist}{missing}(..., platform)

\S4method{avlist}{ANY}(..., platform)

\S4method{avremove}{missing}(..., platform)

\S4method{avremove}{ANY}(..., platform)

\S4method{avbackup}{missing}(..., platform)

\S4method{avbackup}{ANY}(..., platform)

\S4method{avrestore}{missing}(..., platform)

\S4method{avrestore}{ANY}(..., platform)

\S4method{avstorage}{missing}(..., platform)

\S4method{avstorage}{ANY}(..., platform)
}
\arguments{
\item{...}{Arguments passed to the methods.}

\item{platform}{A Platform derived class indicating the AnVIL environment,
currently, \code{azure} and \code{gcp} classes are compatible.}
}
\value{
Methods for the 'missing' and 'ANY' signatures provide a way to
redirect calls to the appropriate method for the current cloud platform.
}
\description{
The \code{AnVILBase} package defines S4 methods for the AnVIL
package. These methods are defined for the 'missing' and 'ANY' signatures.
}
\section{Functions}{
\itemize{
\item \code{avcopy(missing)}: Copy a file from the cloud

\item \code{avcopy(ANY)}: Copy a file from the cloud

\item \code{avlist(missing)}: List files in the cloud

\item \code{avlist(ANY)}: List files in the cloud

\item \code{avremove(missing)}: Remove a file from the cloud

\item \code{avremove(ANY)}: Remove a file from the cloud

\item \code{avbackup(missing)}: Backup a file to the cloud

\item \code{avbackup(ANY)}: Backup a file to the cloud

\item \code{avrestore(missing)}: Restore a file from the cloud

\item \code{avrestore(ANY)}: Restore a file from the cloud

\item \code{avstorage(missing)}: Get the storage location

\item \code{avstorage(ANY)}: Get the storage location

}}
\examples{
findMethods("avcopy")
getMethod("avcopy", c(platform = "missing"))


}
