% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/azure-methods.R
\name{azure-methods}
\alias{azure-methods}
\alias{avcopy,azure-method}
\alias{avlist,azure-method}
\alias{avremove,azure-method}
\alias{avbackup,azure-method}
\alias{avrestore,azure-method}
\alias{avstorage,azure-method}
\title{A number of methods compatible with the Azure platform class.}
\usage{
\S4method{avcopy}{azure}(source, destination, dry = TRUE, ..., platform = cloud_platform())

\S4method{avlist}{azure}(..., platform = cloud_platform())

\S4method{avremove}{azure}(source, recursive = FALSE, ..., platform = cloud_platform())

\S4method{avbackup}{azure}(
  source,
  destination,
  recursive = TRUE,
  ...,
  platform = cloud_platform()
)

\S4method{avrestore}{azure}(
  source,
  destination,
  recursive = TRUE,
  ...,
  platform = cloud_platform()
)

\S4method{avstorage}{azure}(..., platform = cloud_platform())
}
\arguments{
\item{source}{\code{character(1)} A relative file path corresponding to
either the remote (\code{az_copy_from_storage}) or local (\code{az_copy_to_storage})
file location. Remote locations should be relative to the base directory in
the Azure Storage Container e.g., \code{analyses/jupyter.log}.}

\item{destination}{\code{character(1)} A relative file path corresponding to
either the remote (\code{az_copy_to_storage}) or local (\code{az_copy_from_storage})
file location. Remote locations should be relative to the base directory in
the Azure Storage Container. When not specified, it will default to the
base directory of the remote location. The \code{to} path can be a folder path
but must end in a forward slash (\code{/}). If the \code{to} path points to a
non-existent directory, it will be created.}

\item{dry}{\code{logical(1)} Whether to perform a dry run i.e., add the
\code{--dry-run} flag to the command.}

\item{...}{Additional arguments passed to lower level functions (not used)}

\item{platform}{\code{azure()} The cloud platform class to dispatch on as given by
\link[AnVILBase:cloud_platform]{AnVILBase::cloud_platform}. Typically not set manually as
\code{cloud_platform()} returns the \code{"azure"} class for Azure workspaces on
AnVIL.}

\item{recursive}{\code{logical(1)} Whether to recursively move or remove files in
a directory. Only applies to \code{avremove}, \code{avbackup}, and \code{avrestore}.
Default is \code{TRUE} for \code{backup} and \code{restore} operations and \code{FALSE} for
\code{avremove}.}
}
\value{
\itemize{
\item \code{avlist} - a \code{tibble} of files and metadata
\item \code{avcopy} - called for the side effect of copying a file \strong{to} or \strong{from}
the Azure Storage Container depending on the \code{source} and \code{destination}
inputs
\item \code{avremove} - called for the side effect of removing a file or folder
\item \code{avbackup} - called for the side effect of copying a directory \strong{to}
the Azure Storage Container
\item \code{avrestore} - called for the side effect of copying a directory
\strong{from} the Azure Storage Container
\item \code{avstorage} - a URL string of the Azure Storage Container location
\item \code{avworkspaces} - a tibble of workspaces on AnVIL
\item \code{avtable_import} - a response list indicating successful upload
\item \code{avtable_delete_values} - when successful, a \code{NULL} value
}
}
\description{
A number of methods compatible with the Azure platform class.
}
\details{
The \code{recursive} argument for \code{avbackup} and \code{avrestore} is set to
\code{TRUE} by default and \code{FALSE} for \code{avremove}. Note that wildcards are not
supported for local or remote paths.
}
\section{Functions}{
\itemize{
\item \code{avcopy(azure)}: a generalized interface for either
\code{az_copy_from_storage} or \code{az_copy_to_storage}; deduced from the \code{source}
and \code{destination} inputs

\item \code{avlist(azure)}: list all the files in the Azure Storage Container

\item \code{avremove(azure)}: remove a file or directory from the Azure Storage

\item \code{avbackup(azure)}: copy a directory from the workspace environment to
the Azure Storage Container

\item \code{avrestore(azure)}: copy a file or directory from the Azure Storage
Container to the workspace environment

\item \code{avstorage(azure)}: The base URI string used to move data to and from
the Azure Storage Container

}}
\examples{
if (interactive()) {

  avlist()

  ## local -> remote
  ## using general interface avcopy
  avcopy("jupyter.log", "analyses/jupyter.log")

  ## upload a directory
  avbackup("./test/", "analyses/test/")

  ## using general interface az_copy
  avcopy("analyses/jupyter.log", "./jupyter.log")

  ## download a directory
  avrestore("analyses/test/", "./test/")

  avremove("analyses/jupyter.log")

}
}
