% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmr_peak_clustering.R
\name{nmr_build_peak_table}
\alias{nmr_build_peak_table}
\title{Build a peak table from the clustered peak list}
\usage{
nmr_build_peak_table(peak_data, dataset = NULL)
}
\arguments{
\item{peak_data}{A peak list, with the cluster column}

\item{dataset}{A \link{nmr_dataset_1D} object, to get the metadata}
}
\value{
An \link{nmr_dataset_peak_table}, containing the peak table and the annotations
}
\description{
Build a peak table from the clustered peak list
}
\examples{
peak_data <- data.frame(
    NMRExperiment = c("10", "10", "20", "20"),
    peak_id = paste0("Peak", 1:4),
    ppm = c(1, 2, 1.1, 2.1),
    area = c(10, 20, 12, 22)
)
clustering_result <- nmr_peak_clustering(peak_data, num_clusters = 2)
peak_data <- clustering_result$peak_data
peak_table <- nmr_build_peak_table(peak_data)
stopifnot(ncol(peak_table) == 2)
}
