% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmr_detect_peaks_align.R
\name{nmr_align}
\alias{nmr_align}
\title{Align NMR spectra}
\usage{
nmr_align(
  nmr_dataset,
  peak_data,
  NMRExp_ref = NULL,
  maxShift_ppm = 0.0015,
  acceptLostPeak = FALSE
)
}
\arguments{
\item{nmr_dataset}{An \link{nmr_dataset_1D}}

\item{peak_data}{The detected peak data given by \link{nmr_detect_peaks}.}

\item{NMRExp_ref}{NMRExperiment of the reference to use for alignment}

\item{maxShift_ppm}{The maximum shift allowed, in ppm}

\item{acceptLostPeak}{This is an option for users, TRUE is the default value. If the users believe that all the peaks in the peak list are true positive, change it to FALSE.}
}
\value{
An \link{nmr_dataset_1D}, with the spectra aligned
}
\description{
This function is based on \link[speaq:dohCluster]{speaq::dohCluster}.
}
\seealso{
Other alignment functions: 
\code{\link{Pipelines}},
\code{\link{nmr_align_find_ref}()}

Other peak alignment functions: 
\code{\link{nmr_align_find_ref}()}
}
\concept{alignment functions}
\concept{peak alignment functions}
