% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ABplot.R
\name{ABplot}
\alias{ABplot}
\title{Plotting estimates}
\usage{
ABplot(
  pedigree.names,
  output.dir,
  out.name,
  alpha = 0.5,
  geom.point.size = 2,
  geom.line.size = 0.9,
  plot.height = 8,
  plot.width = 11,
  plot.type = "both",
  lsq.line = "theory",
  intract = FALSE
)
}
\arguments{
\item{pedigree.names}{Models output AB*.Rdata}

\item{output.dir}{output directory}

\item{out.name}{filename}

\item{alpha}{ggplot parameters}

\item{geom.point.size}{ggplot parameters}

\item{geom.line.size}{ggplot parameters}

\item{plot.height}{ggplot parameters}

\item{plot.width}{ggplot parameters}

\item{plot.type}{type of plot (data.only, fit.only, both)}

\item{lsq.line}{Least Square Regression line (theory or pred)}

\item{intract}{to see intarctive plot. (useing plotly)}
}
\value{
plot
}
\description{
Plotting Estimating epimutation
}
\examples{
# Get some toy data
file <- system.file("extdata/dm/","Col_CG_global_estimates_ABneutral.Rdata", package="AlphaBeta")
ABplot(pedigree.names=file, output.dir=getwd(), out.name="ABneutral")
}
