% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AffiXcan.R
\name{affiXcanBs}
\alias{affiXcanBs}
\title{Fit linear models and compute ANOVA p-values}
\usage{
affiXcanBs(
  exprMatrix,
  assay,
  regionAssoc,
  pca,
  cov = NULL,
  BPPARAM = bpparam(),
  trainingSamples
)
}
\arguments{
\item{exprMatrix}{A SummarizedExperiment object containing expression data}

\item{assay}{A string with the name of the object in
SummarizedExperiment::assays(exprMatrix) that contains expression values}

\item{regionAssoc}{A data.frame with the associations between regulatory
regions and expressed genes, and with colnames = c("REGULATORY_REGION",
"EXPRESSED_REGION")}

\item{pca}{A list, which is the returningObject$pca from affiXcanPca()}

\item{cov}{Optional; a data.frame with covariates values for the population
structure where the columns are the PCs and the rows are the individual IDs;
default is NULL}

\item{BPPARAM}{A BiocParallelParam object. Default is bpparam(). For
details on BiocParallelParam virtual base class see 
browseVignettes("BiocParallel")}

\item{trainingSamples}{A vector of strings. The identifiers (e.g. row names
of MultiAssayExperiment objects from tbaPaths) of the samples that have to
be considered in the training phase, and not used for the cross-validation}
}
\value{
A list containing lists named as the EXPRESSED_REGIONS found in the
param regionAssoc.
Each of these lists contain three objects:
\itemize{
 \item coefficients: An object containing the coefficients of the principal
 components used in the model, completely similar to the "coefficients"
 from the results of lm()
 \item p.val: The uncorrected anova p-value of the model
 \item r.sq: The coefficient of determination between the real total expression
 values and the imputed GReX, retrived from summary(model)$r.squared
 \item corrected.p.val: The p-value of the model, corrected for multiple
 testing with benjamini-hochberg procedure 
}
}
\description{
Fit linear models and compute ANOVA p-values
}
\examples{
if (interactive()) {
data(exprMatrix)
data(trainingCovariates)
data(regionAssoc)

tbaPaths <- system.file("extdata","training.tba.toydata.rds",
package="AffiXcan")
regionsCount <- overlookRegions(tbaPaths)
assay <- "values"

sampleNames <- colnames(exprMatrix)
nSamples <- length(sampleNames)
sampGroups <- subsetKFold(k=5, n=nSamples)
for (i in seq(length(sampGroups))) {
     sampGroups[[i]] <- colnames(exprMatrix)[sampGroups[[i]]]
}

testingSamples <- sampGroups[[1]]
trainingSamples <- sampleNames[!sampleNames \%in\% testingSamples]

pca <- affiXcanPca(tbaPaths=tbaPaths, varExplained=80, scale=TRUE,
regionsCount=regionsCount, trainingSamples=trainingSamples)

bs <- affiXcanBs(exprMatrix=exprMatrix, assay=assay, regionAssoc=regionAssoc,
pca=pca, cov=trainingCovariates, trainingSamples=trainingSamples)
}
}
