% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AWFisher.R
\name{AWFisher_pvalue}
\alias{AWFisher_pvalue}
\title{AWFisher}
\usage{
AWFisher_pvalue(p.values)
}
\arguments{
\item{p.values}{Input G by K p-value matrix. 
Each row represent a gene and each column represent a study. 
Note that K has to be >=2 and <=100.}
}
\value{
A list consisting of AWFisher pvalues and AWweight.
\item{pvalues}{AWFisher pvalues.}
\item{weights}{G by K binary weight matrix W. 
$W_{gk} = 1$ represents for gene $g$, 
study $k$ contributes to the meta-analysis result. 
$W_{gk} = 0$ otherwise.}
}
\description{
R package for fast computing for adaptively weighted fisher's method
}
\details{
fast computing for adaptively weighted fisher's method
}
\examples{
K <- 40
G <- 10000
p.values = matrix(rbeta(K*G, 1,1), ncol=K)
res = AWFisher_pvalue(p.values)
hist(res$pvalues, breaks=40)
table(rowSums(res$weights))
pvalues=res$pvalues[order(res$pvalues)]
plot(-log10((1:NROW(pvalues))/(1+NROW(pvalues))), 
 -log10(pvalues),xlab='theoretical quantile', ylab='observed quantile')
lines(c(0,100), c(0,100), col=2)
}
\author{
Zhiguang Huo
}
