% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getPSMAttributes.R
\name{getPSMAttributes}
\alias{getPSMAttributes}
\title{Get attributes for PSMs}
\usage{
getPSMAttributes(
  PSM,
  fixedPTMs,
  colOfReporterIonInt,
  groups,
  groupsExcludedFromCV = NA,
  setProgressBar = TRUE
)
}
\arguments{
\item{PSM}{A data frame containing all PSMs used for training.}

\item{fixedPTMs}{A numeric vector with the masses of fixed
post-translational modifications (PTMs) in Da. Other PTMs will be treated as
variable PTMs.}

\item{colOfReporterIonInt}{A vector of column names for reporter ion
intensities across different channels.}

\item{groups}{A vector specifying sample groups.}

\item{groupsExcludedFromCV}{A vector of sample groups excluded from average
CV calculations, which may occur due to a zero spike-in concentration for a
species.}

\item{setProgressBar}{A logical value indicating whether to display a
progress bar.}
}
\value{
A data frame containing the PSM table with attributes required for
the random forest model.
}
\description{
Retrieves attributes required for training or test sets.
}
\examples{
library(ExperimentHub)
library(stringr)
eh <- ExperimentHub()
benchmarkSet3 <- eh[['EH9639']]
# Load sample names (Sample 'H1+Y0_1' ~ Sample 'H1+Y10_2')
samples <- colnames(benchmarkSet3)[
    grep('H1[+]Y[0-9]+_[1-2]', colnames(benchmarkSet3))
]
groups <- str_match(samples, 'H1[+]Y[0-9]+')[, 1]
PSM <- getPSMAttributes(
    PSM=benchmarkSet3,
    fixedPTM=c('304.2071', '125.0476'),
    colOfReporterIonInt=samples,
    groups=groups,
    groupsExcludedFromCV='H1+Y0'
)
}
