% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convertPDFormat.R
\name{convertPDFormat}
\alias{convertPDFormat}
\title{Convert Proteome Discoverer Output to Required Input Format}
\usage{
convertPDFormat(PSM, protein, colOfReporterIonInt)
}
\arguments{
\item{PSM}{A data frame containing the PSM table from Proteome Discoverer to
be converted.}

\item{protein}{A data frame containing the corresponding protein table from
Proteome Discoverer.}

\item{colOfReporterIonInt}{A vector of column names for reporter ion
intensities across different channels.}
}
\value{
A data frame in the format required by AWAggregator.
}
\description{
Converts output from Proteome Discoverer into the input format
required by AWAggregator.
}
\examples{
data(sample.PSM.PD)
data(sample.prot.PD)
# Load sample names (Sample 1 ~ Sample 9)
samples <- colnames(sample.PSM.PD)[grep('Sample', colnames(sample.PSM.PD))]
df <- convertPDFormat(
    PSM=sample.PSM.PD,
    protein=sample.prot.PD,
    colOfReporterIonInt=samples
)
}
