% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aux_plotGeneCount.R
\name{plotGeneCount}
\alias{plotGeneCount}
\title{plotGeneCount}
\usage{
plotGeneCount(exprMat, plotStats = TRUE, verbose = TRUE)
}
\arguments{
\item{exprMat}{Expression matrix (genes as rows, cells as columns)}

\item{plotStats}{Logical. If true, it plots the histogram, otherwise only calculates the percentages of genes detected.}

\item{verbose}{Should the function show progress messages? (TRUE / FALSE)}
}
\value{
Quantiles with the number of genes detected by cell (invisible).
his result is also printed if verbose=TRUE.
}
\description{
Plots a histogram and boxplot for the number of genes
detected in each cell.
}
\details{
It is important to check that most cells have at least the number of
expressed/detected genes that are going to be used to calculate the AUC
(`aucMaxRank` in `calcAUC()`). The histogram provided by
`AUCell_buildRankings()` allows to quickly check this distribution.
`plotGeneCount(exprMatrix)` allows to obtain only the plot before
building the rankings.
}
\examples{
### (Fake expression matrix)
exprMatrix <- matrix(sample(c(rep(0, 500), sample(1:3, 500, replace=TRUE))),
 nrow=20)
rownames(exprMatrix) <- paste("Gene", 1:20, sep="")
colnames(exprMatrix) <- paste("Sample", 1:50, sep="")
###

plotGeneCount(exprMatrix)
title(sub="Fake expression matrix")

}
\seealso{
See the package vignette for more details: \code{vignette("AUCell")}
}
