% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readBamFile.R
\name{readBamFile}
\alias{readBamFile}
\title{read in bam files}
\usage{
readBamFile(
  bamFile,
  which,
  tag = character(0),
  what = c("qname", "flag", "mapq", "isize", "seq", "qual", "mrnm"),
  flag = scanBamFlag(isSecondaryAlignment = FALSE, isUnmappedQuery = FALSE,
    isNotPassingQualityControls = FALSE, isSupplementaryAlignment = FALSE),
  asMates = FALSE,
  bigFile = FALSE,
  ...
)
}
\arguments{
\item{bamFile}{character(1). Bam file name.}

\item{which}{A \link[GenomicRanges:GRanges-class]{GRanges}, \link[IRanges:IntegerRangesList-class]{IntegerRangesList}, 
or any object that can be coerced to a RangesList, or missing object, 
from which a IRangesList instance will be constructed. 
See \link[Rsamtools:ScanBamParam-class]{ScanBamParam}.}

\item{tag}{A vector of characters indicates the tag names to be read.
See \link[Rsamtools:ScanBamParam-class]{ScanBamParam}.}

\item{what}{A character vector naming the fields to return. 
Fields are described on the \link{Rsamtools}[scanBam] help page.}

\item{flag}{An integer(2) vector used to filter reads based on their 
'flag' entry.}

\item{asMates}{logical(1). Paired ends or not}

\item{bigFile}{If the file take too much memory, set it to true to avoid read the reads into memory.
\link[Rsamtools:ScanBamParam-class]{scanBamFlag} helper function.}

\item{...}{parameters used by \link[GenomicAlignments:readGAlignments]{readGAlignmentsList} 
or \link[GenomicAlignments]{readGAlignments}}
}
\value{
A GAlignmentsList object when asMates=TRUE,
otherwise A GAlignments object.
If bigFile is set to TRUE, no reads will be read into memory at this step and 
empty GAlignments/GAlignmentsList will be returned.
}
\description{
wraper for readGAlignments/readGAlignmentsList to read in bam files.
}
\examples{
library(BSgenome.Hsapiens.UCSC.hg19)
which <- as(seqinfo(Hsapiens)["chr1"], "GRanges")
bamfile <- system.file("extdata", "GL1.bam", 
                       package="ATACseqQC", mustWork=TRUE)
readBamFile(bamfile, which=which, asMates=TRUE)
}
\author{
Jianhong Ou
}
