% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pseudoPausingIndex.R
\name{pseudoPausingIndex}
\alias{pseudoPausingIndex}
\title{Simulation pausing index}
\usage{
pseudoPausingIndex(
  obj,
  txs,
  seqlev = intersect(seqlevels(obj), seqlevels(txs)),
  nascentRegion = c(-200, -1),
  pausedRegion = c(1, 200),
  avoidanceRegion = c(21, 60),
  elongationRegion = c(401, 600),
  pseudocount = 1L
)
}
\arguments{
\item{obj}{an object of \link[GenomicAlignments:GAlignments-class]{GAlignments}}

\item{txs}{GRanges of transcripts}

\item{seqlev}{A vector of characters indicates the sequence levels.}

\item{nascentRegion, pausedRegion, avoidanceRegion, elongationRegion}{numeric(2)
 or integer(2).
The start and end position of the pre-initiation complex, paused complex, 
paused complex avoidance region and productive elongation.}

\item{pseudocount}{numeric(1) or integer(1). Pseudocount. Default is 1.}
}
\value{
A object of \link[GenomicRanges:GRanges-class]{GRanges} with pseudo
pausing index.
}
\description{
The polII pausing index is the ratio of the reads density at 
the 5' end of the gene to that in the gene body. This function will simulate
the pausing index by open chromatin coverage instead of PolII signaling.
The pausing index is a raio between aggregate distribution of reads in TSS
and that elongating gene bodys. The default PI = [average coverage of TSS
(+1 to +200bp) - average coverage of avoidance region (+21 to +60bp)] /
the average coverage of in transcripts (+401bp to 600bp).
}
\examples{
 
library(GenomicRanges)
bamfile <- system.file("extdata", "GL1.bam", 
                       package="ATACseqQC", mustWork=TRUE)
gal1 <- readBamFile(bamFile=bamfile, tag=character(0), 
                    which=GRanges("chr1", IRanges(1, 1e6)), 
                    asMates=FALSE)
library(TxDb.Hsapiens.UCSC.hg19.knownGene)
txs <- transcripts(TxDb.Hsapiens.UCSC.hg19.knownGene)
ppi <- pseudoPausingIndex(gal1, txs)
}
\references{
https://doi.org/10.1098%2Frsob.210220; 
https://www.nature.com/articles/nmeth.2688/figures/3
}
\author{
Jianhong Ou
}
