% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ComBat.step2.R
\name{ComBat.step2}
\alias{ComBat.step2}
\title{Perform the second step of ComBat}
\usage{
ComBat.step2(
  testData,
  pcaPlots = FALSE,
  combat_train = NULL,
  plots_to_console = FALSE
)
}
\arguments{
\item{testData}{The input test data to batch correct}

\item{pcaPlots}{a logical value indicating whether or not the function
should create PCA plots. The default is FALSE.}

\item{combat_train}{the ComBat training data data frame. If you do not have
this, the function will attempt to download it from the internet. Please
contact the developers if you have any issues with access to the file.}

\item{plots_to_console}{By default this function will write PDF versions of
the plots. Set this to TRUE to send the plots to the command line. The
default is FALSE.}
}
\value{
A list of data.frames is returned, including control (GFP) and
signature data, as well as the batch corrected test data. This data can go
directly into the runassign.single and runassign.multi functions, or
subsetted to go directly into ASSIGN.
}
\description{
The first ComBat step (on the signatures only) has already been
performed. This step performs batch correction on the test data,
using reference batch ComBat, to prepare the test data for ASSIGN
analysis.
}
\details{
This function downloads the training data from the internet, so an internet
connection is necessary
}
