% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/amaretto_htmlreport.R
\name{AMARETTO_HTMLreport}
\alias{AMARETTO_HTMLreport}
\title{AMARETTO_HTMLreport}
\usage{
AMARETTO_HTMLreport(AMARETTOinit, AMARETTOresults, ProcessedData,
  show_row_names = FALSE, SAMPLE_annotation = NULL, ID = NULL,
  hyper_geo_test_bool = FALSE, hyper_geo_reference = NULL,
  output_address = "./", MSIGDB = TRUE, driverGSEA = TRUE,
  phenotype_association_table = NULL)
}
\arguments{
\item{AMARETTOinit}{AMARETTO initialize output}

\item{AMARETTOresults}{AMARETTO results output}

\item{ProcessedData}{List of processed input data}

\item{show_row_names}{if True, sample names will appear in the heatmap}

\item{SAMPLE_annotation}{SAMPLE annotation will be added to heatmap}

\item{ID}{ID column of the SAMPLE annotation data frame}

\item{hyper_geo_test_bool}{Boolean if a hyper geometric test needs to be performed. If TRUE provide a GMT file in the hyper_geo_reference parameter.}

\item{hyper_geo_reference}{GMT file with gene sets to compare with.}

\item{output_address}{Output directory for the html files.}

\item{MSIGDB}{TRUE if gene sets were retrieved from MSIGDB. Links will be created in the report.}

\item{driverGSEA}{if TRUE, module drivers will also be included in the hypergeometric test.}

\item{phenotype_association_table}{a Data Frame, containing all modules phenotype association data. Optional.}
}
\value{
result
}
\description{
Retrieve an interactive html report, including gene set enrichment analysis if asked for.
}
\examples{
\dontrun{
data('ProcessedDataLIHC')
AMARETTOinit <- AMARETTO_Initialize(ProcessedData = ProcessedDataLIHC,
                                    NrModules = 2, VarPercentage = 50)

AMARETTOresults <- AMARETTO_Run(AMARETTOinit)

AMARETTO_HTMLreport(AMARETTOinit= AMARETTOinit,AMARETTOresults= AMARETTOresults,
                    ProcessedData = ProcessedDataLIHC,
                    hyper_geo_test_bool=FALSE,
                    output_address='./')
}
}
