% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenewiseMethod.R
\name{MaskData}
\alias{MaskData}
\title{Masking of entries for performance evaluation}
\usage{
MaskData(data, write.to.file = FALSE, mask = .1)
}
\arguments{
\item{data}{matrix; raw counts (genes as rows and samples as columns)}

\item{write.to.file}{logical; should the output be written to a file?}

\item{mask}{numeric; ratio of total non-zero samples to be masked per gene
(defaults to .1)}
}
\value{
matrix containing masked raw counts (genes as rows and samples as
columns)
}
\description{
\code{MaskData} sets a portion (\code{mask}) of the non-zero
entries of each row of \code{data} to zero
}
\details{
Sets a portion (\code{mask}) of the non-zero entries of each row of
\code{data} to zero. Result is written to \code{filename}.
}
