/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.classifier.comparison;

import edu.msu.cme.rdp.classifier.comparison.AbstractNode;
import edu.msu.cme.rdp.classifier.comparison.ComparisonBrowserNode;
import edu.msu.cme.rdp.classifier.comparison.ComparisonResultTreeSet;
import edu.msu.cme.rdp.classifier.comparison.SigCalculator;
import edu.msu.cme.rdp.classifier.comparison.Taxon;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class ComparisonBrowserBean {
    private static final int DEFAULT_DEPTH = 0;
    private static final int DISPLAY_LIMIT = 25;
    private static final int MIN_DEPTH = 2;
    private static final int MAX_DEPTH = 10;
    private static final float MIN_CONF = 0.0f;
    private static final float MAX_CONF = 1.0f;
    private static final int MAX_SEQUENCE = 40000;
    private static final float DEFAULT_CONF = 0.8f;
    private int depthValue = 0;
    private String depth;
    private float confidenceValue = 0.8f;
    private String confidence;
    private List errorList;
    private ComparisonBrowserNode currentRoot;
    private ComparisonBrowserNode root;
    private String hierarchyVer;
    private String classifierVer;
    private Date submitDate;
    private String s1Filename;
    private String s2Filename;

    public static int getSeqCountLimit() {
        return 40000;
    }

    public static float getDefaultConfidence() {
        return 0.8f;
    }

    public Date getSubmitDate() {
        return this.submitDate;
    }

    public void setSubmitDate(Date date) {
        this.submitDate = date;
    }

    public String getHierarchyVersion() {
        return this.hierarchyVer;
    }

    public String getClassifierVersion() {
        return this.classifierVer;
    }

    public String getDepth() {
        if (this.depth == null) {
            this.depth = String.valueOf(this.depthValue);
        }
        return this.depth;
    }

    public void setDepth(String depthStr) {
        int depValue;
        block7: {
            block8: {
                if (depthStr == null || depthStr.trim().equals("")) {
                    return;
                }
                try {
                    depValue = Integer.parseInt(depthStr);
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException("Expects display level between 2 and 10");
                }
                if (depValue == 0) break block7;
                if (depValue < 2) break block8;
                if (depValue <= 10) break block7;
            }
            throw new IllegalArgumentException("Expects display level between 2 and 10");
        }
        if (this.depthValue != depValue) {
            this.depthValue = depValue;
            this.depth = String.valueOf(this.depthValue);
        }
    }

    public float getFloatConfidence() {
        if (this.confidence == null) {
            return this.confidenceValue;
        }
        return Float.parseFloat(this.confidence);
    }

    public int getS1Total() {
        return ((AbstractNode)this.root).getS1Count();
    }

    public int getS2Total() {
        return ((AbstractNode)this.root).getS2Count();
    }

    void setS1Filename(String s) {
        this.s1Filename = s;
    }

    void setS2Filename(String s) {
        this.s2Filename = s;
    }

    public String getS1Filename() {
        return this.s1Filename;
    }

    public String getS2Filename() {
        return this.s2Filename;
    }

    public String getConfidence() {
        if (this.confidence == null) {
            this.confidence = String.valueOf(this.confidenceValue);
        }
        return this.confidence;
    }

    public void setConfidence(String confidenceStr) {
        float confValue;
        if (confidenceStr == null || confidenceStr.trim().equals("") || this.root == null) {
            return;
        }
        try {
            confValue = Float.parseFloat(confidenceStr);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Expects cut off value between 0 and 1");
        }
        if (confValue < 0.0f || confValue > 1.0f) {
            throw new IllegalArgumentException("Expects cut off value between 0 and 1");
        }
        if (this.confidenceValue != confValue) {
            this.confidenceValue = confValue;
            this.confidence = String.valueOf(confValue);
            SigCalculator cal = new SigCalculator(((Taxon)((Object)this.root)).getS1Count(), ((Taxon)((Object)this.root)).getS2Count(), this.confidenceValue);
            this.root.changeConfidence(cal);
        }
    }

    public int getSeqErrorCount() {
        if (this.errorList != null) {
            return this.errorList.size();
        }
        return 0;
    }

    public ComparisonBrowserNode getCurrentBrowserRoot() {
        return this.currentRoot;
    }

    public void setCurrentRoot(String tax) {
        int taxid;
        if (tax == null || tax.trim().equals("")) {
            return;
        }
        try {
            taxid = Integer.parseInt(tax);
        }
        catch (NumberFormatException ex) {
            throw new IllegalArgumentException("Expects taxon id in integer format");
        }
        ComparisonBrowserNode bNode = this.root.findNode(taxid);
        if (bNode == null) {
            throw new IllegalArgumentException("Taxon node with id " + tax + " cannot be found");
        }
        this.currentRoot = bNode;
    }

    public void setRoot(ComparisonBrowserNode root) {
        this.root = root;
        this.currentRoot = root;
    }

    public Iterator getLineageList() {
        if (this.currentRoot == null) {
            return null;
        }
        Iterator iter = this.currentRoot.getLineageIterator();
        if (!iter.hasNext()) {
            return null;
        }
        return iter;
    }

    public Iterator getTabularTaxonList() {
        ComparisonResultTreeSet resultSet = new ComparisonResultTreeSet();
        Iterator taxonIt = this.root.getTaxonIterator(10);
        while (taxonIt.hasNext()) {
            resultSet.add(taxonIt.next());
        }
        return resultSet.iterator();
    }

    public Iterator getChildTaxonList() {
        Iterator taxonIt = this.currentRoot.getTaxonIterator(2);
        if (taxonIt.hasNext()) {
            taxonIt.next();
        }
        return taxonIt;
    }

    public Iterator getHierarchyTaxonList() {
        if (this.currentRoot == null) {
            return null;
        }
        Iterator taxonIt = null;
        int returnDepth = 2;
        if (this.depthValue != 0) {
            returnDepth = this.depthValue;
        } else {
            int dp = 2;
            int prevSize = 0;
            while (true) {
                if (dp >= 10 || prevSize >= 30) break;
                taxonIt = this.currentRoot.getTaxonIterator(dp);
                int size = 0;
                while (taxonIt.hasNext()) {
                    taxonIt.next();
                    if (++size < 25) continue;
                }
                if (size == prevSize || size >= 25) {
                    returnDepth = dp;
                    break;
                }
                returnDepth = ++dp;
                prevSize = size;
            }
        }
        return this.currentRoot.getTaxonIterator(returnDepth);
    }

    public Iterator getDetailList() {
        if (this.currentRoot == null) {
            return null;
        }
        return this.currentRoot.getDetailIterator(this.confidenceValue);
    }

    public int getDetailListSize() {
        Iterator it = this.getDetailList();
        int size = 0;
        while (it.hasNext()) {
            ++size;
        }
        return size;
    }

    public void setSeqErrorList(List errorList) {
        this.errorList = errorList;
    }

    public Iterator getSeqErrorList() {
        if (this.errorList == null) {
            return null;
        }
        return this.errorList.iterator();
    }

    public ComparisonBrowserBean(String hver, String cver) {
        this.hierarchyVer = hver;
        this.classifierVer = cver;
    }
}

