## ----eval = FALSE, warning=FALSE, message=FALSE-------------------------------
# if (!requireNamespace("BiocManager", quietly = TRUE)) {
#     install.packages("BiocManager")
# }
# 
# # Install mist from GitHub
# BiocManager::install("https://github.com/dxd429/mist")

## ----eval = FALSE, warning=FALSE, message=FALSE-------------------------------
# if (!requireNamespace("BiocManager", quietly = TRUE)) {
#     install.packages("BiocManager")
# }
# BiocManager::install("mist")

## ----eval=FALSE,warning=FALSE,message=FALSE-----------------------------------
# library(mist)
# vignette("mist")

## ----eval=TRUE, message=FALSE, warning=FALSE----------------------------------
library(mist)
library(SingleCellExperiment)
# Load sample scDNAm data
Dat_sce <- readRDS(system.file("extdata", "group1_sampleData_sce.rds", package = "mist"))

## ----eval=TRUE, message=FALSE, warning=FALSE----------------------------------
# Estimate parameters for single-group
Dat_sce <- estiParam(
    Dat_sce = Dat_sce,
    Dat_name = "Methy_level_group1",
    ptime_name = "pseudotime"
)

# Check the output
head(rowData(Dat_sce)$mist_pars)

## ----eval=TRUE, message=FALSE, warning=FALSE----------------------------------
# Perform differential methylation analysis for the single-group
Dat_sce <- dmSingle(Dat_sce)

# View the top genomic features with drastic methylation changes
head(rowData(Dat_sce)$mist_int)

## ----eval=TRUE, fig.height=5, fig.width=8, message=FALSE, warning=FALSE, out.width='100%'----
# Produce scatterplot with fitted curve of a specific gene
library(ggplot2)
plotGene(Dat_sce = Dat_sce,
         Dat_name = "Methy_level_group1",
         ptime_name = "pseudotime", 
         gene_name = "ENSMUSG00000000037")

## ----eval=TRUE, message=FALSE, warning=FALSE----------------------------------
# Load two-group scDNAm data
Dat_sce_g1 <- readRDS(system.file("extdata", "group1_sampleData_sce.rds", package = "mist"))
Dat_sce_g2 <- readRDS(system.file("extdata", "group2_sampleData_sce.rds", package = "mist"))

## ----eval=TRUE, message=FALSE, warning=FALSE----------------------------------
# Estimate parameters for both groups
Dat_sce_g1 <- estiParam(
     Dat_sce = Dat_sce_g1,
     Dat_name = "Methy_level_group1",
     ptime_name = "pseudotime"
 )

Dat_sce_g2 <- estiParam(
     Dat_sce = Dat_sce_g2,
     Dat_name = "Methy_level_group2",
     ptime_name = "pseudotime"
 ) 

# Check the output
head(rowData(Dat_sce_g1)$mist_pars, n = 3)
head(rowData(Dat_sce_g2)$mist_pars, n = 3)

## ----eval=TRUE, message=FALSE, warning=FALSE----------------------------------
# Perform DM analysis to compare the two groups
dm_results <- dmTwoGroups(
     Dat_sce_g1 = Dat_sce_g1,
     Dat_sce_g2 = Dat_sce_g2
 )

# View the top genomic features with different temporal patterns between groups
head(dm_results)

## ----sessionInfo, echo=FALSE--------------------------------------------------
sessionInfo()

