/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mri;

import edu.rit.mri.SpinSignal;
import edu.rit.numeric.Series;
import edu.rit.numeric.VectorFunction;
import edu.rit.numeric.XYSeries;

public class SpinSignalDifference
implements VectorFunction {
    private int M;
    private int L;
    private Series t_series;
    private Series S_series;

    public SpinSignalDifference(XYSeries xYSeries, int n) {
        this(xYSeries.xSeries(), xYSeries.ySeries(), n);
    }

    public SpinSignalDifference(Series series, Series series2, int n) {
        if (series == null) {
            throw new NullPointerException("SpinSignalDifference(): t_series is null");
        }
        if (series2 == null) {
            throw new NullPointerException("SpinSignalDifference(): S_series is null");
        }
        if (series.length() == 0) {
            throw new IllegalArgumentException("SpinSignalDifference(): t_series is zero length, illegal");
        }
        if (series2.length() == 0) {
            throw new IllegalArgumentException("SpinSignalDifference(): S_series is zero length, illegal");
        }
        if (series.length() != series2.length()) {
            throw new IllegalArgumentException("SpinSignalDifference(): t_series and S_series have different lengths, illegal");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("SpinSignalDifference(): L (= " + n + ") <= 0, illegal");
        }
        this.M = series.length();
        this.L = n;
        this.t_series = series;
        this.S_series = series2;
    }

    public int resultLength() {
        return this.M;
    }

    public int argumentLength() {
        return this.L << 1;
    }

    public void f(double[] dArray, double[] dArray2) {
        int n;
        for (n = 0; n < this.M; ++n) {
            dArray2[n] = -this.S_series.x(n);
        }
        for (n = 0; n < this.M; ++n) {
            double d = this.t_series.x(n);
            for (int i = 0; i < this.L; ++i) {
                double d2 = dArray[i << 1];
                double d3 = dArray[(i << 1) + 1];
                int n2 = n;
                dArray2[n2] = dArray2[n2] + SpinSignal.S(d2, d3, d);
            }
        }
    }

    public void df(double[] dArray, double[][] dArray2) {
        for (int i = 0; i < this.M; ++i) {
            double d = this.t_series.x(i);
            double[] dArray3 = dArray2[i];
            for (int j = 0; j < this.L; ++j) {
                double d2 = dArray[j << 1];
                double d3 = dArray[(j << 1) + 1];
                double d4 = 2.0 * Math.exp(-d3 * d);
                dArray3[j << 1] = 1.0 - d4;
                dArray3[(j << 1) + 1] = d2 * d * d4;
            }
        }
    }
}

