/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.image;

import edu.rit.image.PJGGrayImage;
import java.util.Arrays;

public class GrayImageRow {
    public static final PJGGrayImage.Interpretation ZERO_IS_WHITE = PJGGrayImage.Interpretation.ZERO_IS_WHITE;
    public static final PJGGrayImage.Interpretation ZERO_IS_BLACK = PJGGrayImage.Interpretation.ZERO_IS_BLACK;
    PJGGrayImage.Transformation myTransformation = PJGGrayImage.ZERO_IS_BLACK_TRANSFORMATION;
    byte[] myArray;

    public GrayImageRow(byte[] byArray) {
        this.setArray(byArray);
    }

    public byte[] getArray() {
        return this.myArray;
    }

    public void setArray(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("GrayImageRow.setArray(): theArray is null");
        }
        this.myArray = byArray;
    }

    public PJGGrayImage.Interpretation getInterpretation() {
        if (this.myTransformation == PJGGrayImage.ZERO_IS_WHITE_TRANSFORMATION) {
            return ZERO_IS_WHITE;
        }
        return ZERO_IS_BLACK;
    }

    public void setInterpretation(PJGGrayImage.Interpretation interpretation) {
        switch (interpretation) {
            case ZERO_IS_WHITE: {
                this.myTransformation = PJGGrayImage.ZERO_IS_WHITE_TRANSFORMATION;
                break;
            }
            case ZERO_IS_BLACK: {
                this.myTransformation = PJGGrayImage.ZERO_IS_BLACK_TRANSFORMATION;
            }
        }
    }

    public int getIntPixel(int n) {
        return this.myTransformation.inverseTransformInt(this.myArray[n]);
    }

    public float getPixel(int n) {
        return this.myTransformation.inverseTransformFloat(this.myArray[n]);
    }

    public void setIntPixel(int n, int n2) {
        this.myArray[n] = this.myTransformation.transformInt(n2);
    }

    public void setPixel(int n, float f) {
        this.myArray[n] = this.myTransformation.transformFloat(f);
    }

    public void fill(int n) {
        Arrays.fill(this.myArray, this.myTransformation.transformInt(n));
    }

    public void fill(float f) {
        Arrays.fill(this.myArray, this.myTransformation.transformFloat(f));
    }
}

