/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.draw.item;

import edu.rit.draw.Drawing;
import edu.rit.draw.item.Arrow;
import edu.rit.draw.item.Outline;
import edu.rit.draw.item.OutlinedItem;
import edu.rit.draw.item.Point;
import edu.rit.draw.item.Size;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class Bow
extends OutlinedItem
implements Externalizable {
    public static final Arrow NORMAL_START_ARROW = Arrow.NONE;
    public static final Arrow NORMAL_END_ARROW = Arrow.NONE;
    public static final double NORMAL_CURVE = 0.5;
    private static final long serialVersionUID = 7585879104799512917L;
    Point myStartPoint;
    Point myEndPoint;
    Arrow myStartArrow = theDefaultStartArrow;
    Arrow myEndArrow = theDefaultEndArrow;
    double myCurve = theDefaultCurve;
    static Arrow theDefaultStartArrow = NORMAL_START_ARROW;
    static Arrow theDefaultEndArrow = NORMAL_END_ARROW;
    static double theDefaultCurve = 0.5;
    Point myNw;
    Point mySe;
    Size mySize;
    double x1;
    double y1;
    double x2;
    double y2;
    double x3;
    double y3;
    double xb;
    double yb;

    public Bow() {
    }

    public Bow(Bow bow) {
        super(bow);
        this.myStartPoint = bow.myStartPoint;
        this.myEndPoint = bow.myEndPoint;
        this.myStartArrow = bow.myStartArrow;
        this.myEndArrow = bow.myEndArrow;
        this.myCurve = bow.myCurve;
    }

    public static Arrow defaultStartArrow() {
        return theDefaultStartArrow;
    }

    public static void defaultStartArrow(Arrow arrow) {
        if (arrow == null) {
            throw new NullPointerException();
        }
        theDefaultStartArrow = arrow;
    }

    public static Arrow defaultEndArrow() {
        return theDefaultEndArrow;
    }

    public static void defaultEndArrow(Arrow arrow) {
        if (arrow == null) {
            throw new NullPointerException();
        }
        theDefaultEndArrow = arrow;
    }

    public static double defaultCurve() {
        return theDefaultCurve;
    }

    public static void defaultCurve(double d) {
        theDefaultCurve = d;
    }

    public Size size() {
        this.computeBoundingBox();
        return this.mySize;
    }

    public double width() {
        this.computeBoundingBox();
        return this.mySize.width;
    }

    public double height() {
        this.computeBoundingBox();
        return this.mySize.height;
    }

    public Point nw() {
        this.computeBoundingBox();
        return this.myNw;
    }

    public Bow outline(Outline outline) {
        this.doOutline(outline);
        return this;
    }

    public Point start() {
        return this.myStartPoint;
    }

    public Bow start(double d, double d2) {
        this.myStartPoint = new Point(d, d2);
        return this;
    }

    public Bow start(Point point) {
        if (point == null) {
            throw new NullPointerException();
        }
        this.myStartPoint = point;
        return this;
    }

    public Point end() {
        return this.myEndPoint;
    }

    public Bow end(double d, double d2) {
        this.myEndPoint = new Point(d, d2);
        return this;
    }

    public Bow end(Point point) {
        if (point == null) {
            throw new NullPointerException();
        }
        this.myEndPoint = point;
        return this;
    }

    public Arrow startArrow() {
        return this.myStartArrow;
    }

    public Bow startArrow(Arrow arrow) {
        if (arrow == null) {
            throw new NullPointerException();
        }
        this.myStartArrow = arrow;
        return this;
    }

    public Arrow endArrow() {
        return this.myEndArrow;
    }

    public Bow endArrow(Arrow arrow) {
        if (arrow == null) {
            throw new NullPointerException();
        }
        this.myEndArrow = arrow;
        return this;
    }

    public double curve() {
        return this.myCurve;
    }

    public Bow curve(double d) {
        this.myCurve = d;
        return this;
    }

    public Bow flip() {
        this.myCurve = -this.myCurve;
        return this;
    }

    public Bow add() {
        this.doAdd(Drawing.defaultDrawing());
        return this;
    }

    public Bow add(Drawing drawing) {
        this.doAdd(drawing);
        return this;
    }

    public Bow addFirst() {
        this.doAddFirst(Drawing.defaultDrawing());
        return this;
    }

    public Bow addFirst(Drawing drawing) {
        this.doAddFirst(drawing);
        return this;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeObject(this.myStartPoint);
        objectOutput.writeObject(this.myEndPoint);
        objectOutput.writeObject(this.myStartArrow);
        objectOutput.writeObject(this.myEndArrow);
        objectOutput.writeDouble(this.myCurve);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        super.readExternal(objectInput);
        this.myStartPoint = (Point)objectInput.readObject();
        this.myEndPoint = (Point)objectInput.readObject();
        this.myStartArrow = (Arrow)objectInput.readObject();
        this.myEndArrow = (Arrow)objectInput.readObject();
        this.myCurve = objectInput.readDouble();
        this.myNw = null;
        this.mySe = null;
        this.mySize = null;
    }

    public void draw(Graphics2D graphics2D) {
        double d;
        double d2;
        double d3;
        super.draw(graphics2D);
        GeneralPath generalPath = this.computePath();
        this.myOutline.setGraphicsContext(graphics2D);
        graphics2D.draw(generalPath);
        if (this.myStartArrow == null && this.myEndArrow == null) {
            return;
        }
        float f = this.myOutline.getStrokeWidth();
        graphics2D.setStroke(new BasicStroke(f));
        if (this.myStartArrow != null) {
            d3 = this.x1 - this.x2;
            d2 = this.y1 - this.y2;
            d = d3 == 0.0 && d2 == 0.0 ? 0.0 : Math.atan2(d2, d3);
            this.myStartArrow.draw(graphics2D, f, this.x1, this.y1, d);
        }
        if (this.myEndArrow != null) {
            d3 = this.x3 - this.x2;
            d2 = this.y3 - this.y2;
            d = d3 == 0.0 && d2 == 0.0 ? 0.0 : Math.atan2(d2, d3);
            this.myEndArrow.draw(graphics2D, f, this.x3, this.y3, d);
        }
    }

    private void computeControlPoints() {
        this.x1 = this.myStartPoint.x();
        this.y1 = this.myStartPoint.y();
        this.x3 = this.myEndPoint.x();
        this.y3 = this.myEndPoint.y();
        double d = 0.5 * (this.x1 + this.x3);
        double d2 = 0.5 * (this.y1 + this.y3);
        double d3 = this.x3 - this.x1;
        double d4 = this.y3 - this.y1;
        double d5 = Math.sqrt(d3 * d3 + d4 * d4);
        double d6 = d3 / d5;
        double d7 = d4 / d5;
        double d8 = -d7;
        double d9 = d6;
        this.x2 = d + 0.5 * d5 * this.myCurve * d8;
        this.y2 = d2 + 0.5 * d5 * this.myCurve * d9;
        this.xb = d + 0.25 * d5 * this.myCurve * d8;
        this.yb = d2 + 0.25 * d5 * this.myCurve * d9;
    }

    private void computeBoundingBox() {
        if (this.myNw == null) {
            this.computeControlPoints();
            this.myNw = new Point(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
            this.mySe = new Point(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
            Point point = new Point(this.x1, this.y1);
            this.myNw = this.myNw.min(point);
            this.mySe = this.mySe.max(point);
            point = new Point(this.xb, this.yb);
            this.myNw = this.myNw.min(point);
            this.mySe = this.mySe.max(point);
            point = new Point(this.x3, this.y3);
            this.myNw = this.myNw.min(point);
            this.mySe = this.mySe.max(point);
            this.mySize = this.mySe.difference(this.myNw);
        }
    }

    private GeneralPath computePath() {
        this.computeControlPoints();
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)this.x1, (float)this.y1);
        generalPath.quadTo((float)this.x2, (float)this.y2, (float)this.x3, (float)this.y3);
        return generalPath;
    }
}

