/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.compbio.phyl;

import edu.rit.compbio.phyl.TreeDrawing;
import edu.rit.draw.Drawing;
import java.io.File;

public class DrawTree {
    private DrawTree() {
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length < 2 || stringArray.length > 3) {
            DrawTree.usage();
        }
        String string = stringArray[0];
        File file = new File(stringArray[1]);
        TreeDrawing treeDrawing = new TreeDrawing();
        if (stringArray.length >= 3) {
            treeDrawing.setBranchLengthFormat(stringArray[2]);
        }
        try {
            treeDrawing.draw(string);
        }
        catch (TreeDrawing.SyntaxException syntaxException) {
            syntaxException.printSyntaxError(System.err);
            System.exit(1);
        }
        Drawing.write(file);
    }

    private static void usage() {
        System.err.println("Usage: java edu.rit.compbio.phyl.DrawTree \"<tree>\" <file> [<format>]");
        System.err.println("<tree> = Tree in Newick Standard format");
        System.err.println("<file> = Drawing file name");
        System.err.println("<format> = DecimalFormat string for branch lengths (default: \"0.00\")");
        System.exit(1);
    }
}

