/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.rdb;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.bridgedb.IDMapperException;
import org.bridgedb.rdb.SimpleGdb;
import org.bridgedb.rdb.SimpleGdbImpl2;
import org.bridgedb.rdb.SimpleGdbImpl3;
import org.bridgedb.rdb.SimpleGdbImpl4;

public final class SimpleGdbFactory {
    private SimpleGdbFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimpleGdb createInstance(String dbName, String connectionString) throws IDMapperException {
        if (connectionString == null) {
            throw new NullPointerException();
        }
        int version = 0;
        Connection con = null;
        ResultSet r = null;
        Statement stmt = null;
        try {
            try {
                con = DriverManager.getConnection(connectionString);
                stmt = con.createStatement();
            }
            catch (SQLException e) {
                throw new IDMapperException("Could not connect to database: " + e.getMessage(), (Throwable)e);
            }
            try {
                r = stmt.executeQuery("SELECT schemaversion FROM info");
                if (r.next()) {
                    version = r.getInt(1);
                }
            }
            catch (SQLException e) {
                throw new IDMapperException("Database schema error, info table or schemaversion column missing: " + e.getMessage(), (Throwable)e);
            }
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (SQLException sQLException) {}
            }
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        switch (version) {
            case 2: {
                return new SimpleGdbImpl2(dbName, connectionString);
            }
            case 3: {
                return new SimpleGdbImpl3(dbName, connectionString);
            }
            case 4: {
                return new SimpleGdbImpl4(dbName, connectionString);
            }
        }
        throw new IDMapperException("Unrecognized schema version '" + version + "', please make sure you have the latest version of this software and databases");
    }
}

