/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.readseq.readers;

import edu.msu.cme.rdp.readseq.SequenceFormat;
import edu.msu.cme.rdp.readseq.readers.SeqReader;
import edu.msu.cme.rdp.readseq.readers.Sequence;
import edu.msu.cme.rdp.readseq.readers.core.SeqReaderCore;
import edu.msu.cme.rdp.readseq.utils.SeqUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class SequenceReader
implements SeqReader {
    private SeqReaderCore core;
    private SequenceFormat format;

    public SequenceReader(File f) throws IOException {
        this.core = SeqUtils.getSeqReaderCore(f);
        this.format = SeqUtils.guessFileFormat(f);
    }

    public SequenceReader(InputStream in) throws IOException {
        this.core = SeqUtils.getSeqReaderCore(in);
        this.format = SequenceFormat.UNKNOWN;
    }

    @Override
    public SequenceFormat getFormat() {
        return this.format;
    }

    public long getPosition() {
        return this.core.getPosition();
    }

    public SequenceFormat getSeqFileFormat() {
        return this.format;
    }

    public Sequence readNextSequence() throws IOException {
        Sequence seq = this.core.readNextSequence();
        if (seq != null) {
            seq.setSeqString(SeqUtils.filterSeqString(seq.getSeqString(), false));
        }
        return seq;
    }

    @Override
    public void close() throws IOException {
        this.core.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Sequence> readFully(File f) throws IOException {
        SequenceReader reader = new SequenceReader(f);
        ArrayList<Sequence> ret = new ArrayList<Sequence>();
        try {
            Sequence seq;
            while ((seq = reader.readNextSequence()) != null) {
                ret.add(seq);
            }
            ArrayList<Sequence> arrayList = ret;
            return arrayList;
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Sequence> readFully(InputStream f) throws IOException {
        SequenceReader reader = new SequenceReader(f);
        ArrayList<Sequence> ret = new ArrayList<Sequence>();
        try {
            Sequence seq;
            while ((seq = reader.readNextSequence()) != null) {
                ret.add(seq);
            }
            ArrayList<Sequence> arrayList = ret;
            return arrayList;
        }
        finally {
            reader.close();
        }
    }
}

