/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.bio.seq.db.SequenceDBWrapper;

public class SubSequenceDB
extends SequenceDBWrapper {
    private final Set ids;

    public SubSequenceDB(SequenceDB sequenceDB, Set set) throws BioException {
        super(sequenceDB);
        this.ids = new HashSet(set);
        Set set2 = sequenceDB.ids();
        if (!set2.containsAll(set)) {
            throw new BioException("IDs must all be contained in the parent database " + sequenceDB.getName());
        }
    }

    public String getName() {
        return String.valueOf(this.getParent().getName()) + " subset " + this.ids.toString();
    }

    public Sequence getSequence(String string) throws BioException {
        if (!this.ids.contains(string)) {
            throw new BioException("No sequence for " + string + " found in database " + this.getName());
        }
        return this.getParent().getSequence(string);
    }

    public Set ids() {
        return Collections.unmodifiableSet(this.ids);
    }
}

