/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dp;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.biojava.bio.BioError;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.SimpleDistribution;
import org.biojava.bio.dp.EmissionState;
import org.biojava.bio.dp.IllegalTransitionException;
import org.biojava.bio.dp.MagicalState;
import org.biojava.bio.dp.MarkovModel;
import org.biojava.bio.dp.ModelInState;
import org.biojava.bio.dp.State;
import org.biojava.bio.dp.Transition;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.SimpleAlphabet;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class SimpleMarkovModel
implements MarkovModel,
Serializable {
    public static final long serialVersionUID = -3043028839927615753L;
    private final Alphabet emissionAlpha;
    private final FiniteAlphabet stateAlpha;
    private final MagicalState magicalState;
    private final Map transFrom;
    private final Map transTo;
    private final Map transWeights;
    private transient ChangeSupport changeSupport;
    private transient MarkovModel.DistributionForwarder distForwarder;
    private Transition _tran = new Transition(null, null);

    public SimpleMarkovModel(int n, Alphabet alphabet) {
        this.transFrom = new HashMap();
        this.transTo = new HashMap();
        this.transWeights = new HashMap();
        this.emissionAlpha = alphabet;
        this.stateAlpha = new SimpleAlphabet();
        this.magicalState = MagicalState.getMagicalState(alphabet, n);
        try {
            this.addState(this.magicalState);
        }
        catch (IllegalSymbolException illegalSymbolException) {
            throw new BioError(illegalSymbolException, "Assertion failure: Couldn't add magical state");
        }
        catch (ChangeVetoException changeVetoException) {
            throw new BioError(changeVetoException, "Assertion failure: Couldn't add magical state");
        }
    }

    public SimpleMarkovModel(int n, Alphabet alphabet, String string) {
        this(n, alphabet);
        ((SimpleAlphabet)this.stateAlpha).setName(string);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.generateChangeSupport(null);
        this.changeSupport.addChangeListener(changeListener);
    }

    public void addChangeListener(ChangeListener changeListener, ChangeType changeType) {
        this.generateChangeSupport(changeType);
        this.changeSupport.addChangeListener(changeListener, changeType);
    }

    public void addState(State state) throws IllegalSymbolException, ChangeVetoException {
        int n;
        if (state instanceof MagicalState && state != this.magicalState) {
            throw new IllegalSymbolException("Can not add a MagicalState");
        }
        if (this.stateAlphabet().contains(state)) {
            throw new IllegalSymbolException("We already contain " + state.getName());
        }
        if (state instanceof EmissionState && (n = ((EmissionState)state).getAdvance().length) != this.heads()) {
            throw new IllegalSymbolException("This model " + this.stateAlphabet().getName() + " has " + this.heads() + " heads, but the state " + state.getName() + " has " + n + " heads");
        }
        if (state instanceof ModelInState && (n = ((ModelInState)state).getModel().heads()) != this.heads()) {
            throw new IllegalSymbolException("This model " + this.stateAlphabet().getName() + " has " + this.heads() + " heads, but the model-in-state " + state.getName() + " has " + n + " heads");
        }
        if (this.changeSupport == null) {
            this.doAddState(state);
        } else {
            ChangeSupport changeSupport = this.changeSupport;
            synchronized (changeSupport) {
                ChangeEvent changeEvent = new ChangeEvent(this, MarkovModel.ARCHITECTURE, state, null);
                this.changeSupport.firePreChangeEvent(changeEvent);
                this.doAddState(state);
                this.changeSupport.firePostChangeEvent(changeEvent);
            }
        }
    }

    public boolean containsTransition(State state, State state2) throws IllegalSymbolException {
        this.stateAlphabet().validate(state2);
        return this.transitionsFrom(state).contains(state2);
    }

    public void createTransition(State state, State state2) throws IllegalSymbolException, ChangeVetoException {
        this.stateAlphabet().validate(state);
        this.stateAlphabet().validate(state2);
        ChangeEvent changeEvent = new ChangeEvent(this, MarkovModel.ARCHITECTURE, new Object[]{state, state2}, null);
        FiniteAlphabet finiteAlphabet = this.transitionsFrom(state);
        FiniteAlphabet finiteAlphabet2 = this.transitionsTo(state2);
        if (finiteAlphabet.contains(state2)) {
            throw new ChangeVetoException(changeEvent, "Transition already exists: " + state.getName() + " -> " + state2.getName());
        }
        if (this.changeSupport == null) {
            finiteAlphabet.addSymbol(state2);
            finiteAlphabet2.addSymbol(state);
        } else {
            ChangeSupport changeSupport = this.changeSupport;
            synchronized (changeSupport) {
                this.changeSupport.firePreChangeEvent(changeEvent);
                finiteAlphabet.addSymbol(state2);
                finiteAlphabet2.addSymbol(state);
                this.changeSupport.firePostChangeEvent(changeEvent);
            }
        }
    }

    public void destroyTransition(State state, State state2) throws IllegalSymbolException, ChangeVetoException {
        this.stateAlphabet().validate(state);
        this.stateAlphabet().validate(state2);
        FiniteAlphabet finiteAlphabet = this.transitionsFrom(state);
        FiniteAlphabet finiteAlphabet2 = this.transitionsTo(state2);
        ChangeEvent changeEvent = new ChangeEvent(this, MarkovModel.ARCHITECTURE, null, new Object[]{state, state2});
        if (!finiteAlphabet.contains(state2)) {
            throw new ChangeVetoException(changeEvent, "Transition does not exists: " + state.getName() + " -> " + state2.getName());
        }
        Distribution distribution = this.getWeights(state);
        double d = distribution.getWeight(state2);
        if (d != 0.0) {
            throw new ChangeVetoException(changeEvent, "Can't remove transition as its weight is not zero: " + state.getName() + " -> " + state2.getName() + " = " + d);
        }
        if (this.changeSupport == null) {
            this.transitionsFrom(state).removeSymbol(state2);
            this.transitionsTo(state2).removeSymbol(state);
        } else {
            ChangeSupport changeSupport = this.changeSupport;
            synchronized (changeSupport) {
                this.changeSupport.firePreChangeEvent(changeEvent);
                this.transitionsFrom(state).removeSymbol(state2);
                this.transitionsTo(state2).removeSymbol(state);
                this.changeSupport.firePostChangeEvent(changeEvent);
            }
        }
    }

    private void doAddState(State state) throws IllegalSymbolException, ChangeVetoException {
        ((SimpleAlphabet)this.stateAlphabet()).addSymbol(state);
        SimpleAlphabet simpleAlphabet = new SimpleAlphabet("Transitions from " + state.getName());
        this.transFrom.put(state, simpleAlphabet);
        this.transTo.put(state, new SimpleAlphabet("Transitions to " + state.getName()));
        this.transWeights.put(state, new SimpleDistribution(simpleAlphabet));
        ((SimpleAlphabet)this.stateAlphabet()).addSymbol(state);
        if (state instanceof EmissionState) {
            Distribution distribution = ((EmissionState)state).getDistribution();
            if (this.distForwarder != null) {
                distribution.addChangeListener(this.distForwarder, Distribution.WEIGHTS);
                distribution.addChangeListener(this.distForwarder, Distribution.NULL_MODEL);
            }
        }
    }

    private void doRemoveState(State state) throws IllegalSymbolException {
        ((SimpleAlphabet)this.stateAlphabet()).removeSymbol(state);
        this.transFrom.remove(state);
        this.transTo.remove(state);
        if (state instanceof EmissionState) {
            Distribution distribution = ((EmissionState)state).getDistribution();
            if (this.distForwarder != null) {
                state.removeChangeListener(this.distForwarder, Distribution.NULL_MODEL);
                state.removeChangeListener(this.distForwarder, Distribution.WEIGHTS);
            }
        }
    }

    public Alphabet emissionAlphabet() {
        return this.emissionAlpha;
    }

    protected void generateChangeSupport(ChangeType changeType) {
        if (this.changeSupport == null) {
            this.changeSupport = new ChangeSupport();
        }
        if ((changeType == null || changeType == MarkovModel.PARAMETER) && this.distForwarder == null) {
            this.distForwarder = new MarkovModel.DistributionForwarder(this, this.changeSupport);
            Iterator iterator = this.stateAlpha.iterator();
            while (iterator.hasNext()) {
                State state = (State)iterator.next();
                if (!(state instanceof EmissionState)) continue;
                EmissionState emissionState = (EmissionState)state;
                Distribution distribution = emissionState.getDistribution();
                distribution.addChangeListener(this.distForwarder, Distribution.WEIGHTS);
                distribution.addChangeListener(this.distForwarder, Distribution.NULL_MODEL);
            }
        }
    }

    public Distribution getWeights(State state) throws IllegalSymbolException {
        this.stateAlphabet().validate(state);
        Distribution distribution = (Distribution)this.transWeights.get(state);
        if (distribution == null) {
            throw new BioError("Model does contain " + state.getName() + " but the associated transition distribution is missing.");
        }
        return distribution;
    }

    public int heads() {
        return this.magicalState().getAdvance().length;
    }

    public MagicalState magicalState() {
        return this.magicalState;
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener, ChangeType changeType) {
        this.changeSupport.removeChangeListener(changeListener, changeType);
    }

    public void removeState(State state) throws IllegalSymbolException, IllegalTransitionException, ChangeVetoException {
        this.stateAlphabet().validate(state);
        if (state instanceof MagicalState) {
            throw new IllegalSymbolException("You can not remove the MagicalState");
        }
        FiniteAlphabet finiteAlphabet = this.transitionsFrom(state);
        if (finiteAlphabet.size() != 0) {
            throw new IllegalTransitionException(state, (State)finiteAlphabet.iterator().next(), "You can not remove a state untill all transitions to and from it have been destroyed");
        }
        finiteAlphabet = this.transitionsTo(state);
        if (finiteAlphabet.size() != 0) {
            throw new IllegalTransitionException((State)finiteAlphabet.iterator().next(), state, "You can not remove a state untill all transitions to and from it have been destroyed");
        }
        if (this.changeSupport == null) {
            this.doRemoveState(state);
        } else {
            ChangeSupport changeSupport = this.changeSupport;
            synchronized (changeSupport) {
                ChangeEvent changeEvent = new ChangeEvent(this, MarkovModel.ARCHITECTURE, null, state);
                this.changeSupport.firePreChangeEvent(changeEvent);
                this.doRemoveState(state);
                this.changeSupport.firePostChangeEvent(changeEvent);
            }
        }
    }

    public void setWeights(State state, Distribution distribution) throws IllegalSymbolException, IllegalAlphabetException {
        FiniteAlphabet finiteAlphabet = this.transitionsFrom(state);
        if (distribution.getAlphabet() != finiteAlphabet) {
            throw new IllegalAlphabetException("Can't set distribution from state " + state.getName() + " as the distribution alphabet is not the alphabet of transitions: " + finiteAlphabet.getName() + " and " + distribution.getAlphabet().getName());
        }
        this.transWeights.put(state, distribution);
    }

    public FiniteAlphabet stateAlphabet() {
        return this.stateAlpha;
    }

    public FiniteAlphabet transitionsFrom(State state) throws IllegalSymbolException {
        this.stateAlphabet().validate(state);
        FiniteAlphabet finiteAlphabet = (FiniteAlphabet)this.transFrom.get(state);
        if (finiteAlphabet == null) {
            throw new BioError("State " + state.getName() + " is known in states " + this.stateAlphabet().getName() + " but is not listed in the transFrom table");
        }
        return finiteAlphabet;
    }

    public FiniteAlphabet transitionsTo(State state) throws IllegalSymbolException {
        this.stateAlphabet().validate(state);
        FiniteAlphabet finiteAlphabet = (FiniteAlphabet)this.transTo.get(state);
        if (finiteAlphabet == null) {
            throw new BioError("State " + state + " is known in states " + this.stateAlphabet().getName() + " but is not listed in the transTo table");
        }
        return finiteAlphabet;
    }
}

