% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqpac_generics_methods.R
\name{show.PAC}
\alias{show.PAC}
\title{show(PAC)}
\usage{
show.PAC(object)
}
\arguments{
\item{object}{A S4 object of class PAC.}
}
\value{
Simple statistical overview of a PAC-object.
}
\description{
Overview (show method) of a S4 PAC
}
\examples{

load(system.file("extdata", "drosophila_sRNA_pac_filt_anno.Rdata", 
                  package = "seqpac", mustWork = TRUE))

# extra fuctionality with s4 PAC-object:
names(pac)
length(pac)
nrow(pac)
ncol(pac)
rownames(pac)
colnames(pac)
pheno(pac) 
head(anno(pac))
head(counts(pac))
head(norm(pac)$cpm)

}
\seealso{
Other PAC methods: 
\code{\link{anno}()},
\code{\link{counts}()},
\code{\link{names,PAC-method}},
\code{\link{norm}()},
\code{\link{pheno}()},
\code{\link{summary}()}
}
\concept{PAC methods}
