% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tuberculosis.R
\name{tuberculosis}
\alias{tuberculosis}
\title{find/get tuberculosis gene expression data}
\usage{
tuberculosis(pattern, dryrun = TRUE)
}
\arguments{
\item{pattern}{regular expression pattern to look for in the titles of
resources available in tuberculosis; "." will return all resources}

\item{dryrun}{if TRUE (the default), a character vector of resource names is
returned invisibly; if FALSE, a list of resources is returned}
}
\value{
if dryrun = TRUE, a character vector of resource names is returned
invisibly; if dryrun = FALSE, a list of resources is returned
}
\description{
To find or get tuberculosis gene expression data, users will use the
\code{tuberculosis} function. The \code{dryrun} argument allows users to test a query
prior to returning resources. When \code{dryrun = TRUE}, the function will print
the names of matching resources as a message and return them invisibly as a
character vector. When \code{dryrun = FALSE}, the function will either download
resources from \code{ExperimentHub} or load them from the user’s local cache. If a
resource has multiple creation dates, the most recent is selected by default;
add a date to override this behavior.
}
\examples{
tuberculosis("GSE103147")

}
