% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_grid_gene.R
\name{vis_grid_gene}
\alias{vis_grid_gene}
\title{Sample spatial gene visualization grid}
\usage{
vis_grid_gene(
  spe,
  geneid = rowData(spe)$gene_search[1],
  pdf_file,
  assayname = "logcounts",
  minCount = 0,
  return_plots = FALSE,
  spatial = TRUE,
  viridis = TRUE,
  height = 24,
  width = 36,
  image_id = "lowres",
  alpha = NA,
  cont_colors = if (viridis) viridisLite::viridis(21) else c("aquamarine4",
    "springgreen", "goldenrod", "red"),
  sample_order = unique(spe$sample_id),
  point_size = 2,
  auto_crop = TRUE,
  na_color = "#CCCCCC40",
  is_stitched = FALSE,
  cap_percentile = 1,
  ...
)
}
\arguments{
\item{spe}{A
\link[SpatialExperiment:SpatialExperiment]{SpatialExperiment-class}
object. See \code{\link[=fetch_data]{fetch_data()}} for how to download some example objects or
\code{\link[=read10xVisiumWrapper]{read10xVisiumWrapper()}} to read in \code{spaceranger --count} output files and
build your own \code{spe} object.}

\item{geneid}{A \code{character()} specifying the gene ID(s) stored in
\code{rowData(spe)$gene_search} or a continuous variable(s) stored in
\code{colData(spe)} to visualize. For each ID, if \code{rowData(spe)$gene_search} is
missing, then \code{rownames(spe)} is used to search for the gene ID. When a
vector of length > 1 is supplied, the continuous variables are combined
according to \code{multi_gene_method}, producing a single value for each spot.}

\item{pdf_file}{A \code{character(1)} specifying the path for the resulting PDF.}

\item{assayname}{The name of the \code{assays(spe)} to use for extracting the
gene expression data. Defaults to \code{logcounts}.}

\item{minCount}{A \code{numeric(1)} specifying the minimum gene expression (or
value in the continuous variable) to visualize. Values at or below this
threshold will be set to \code{NA}. Defaults to \code{0}.}

\item{return_plots}{A \code{logical(1)} indicating whether to print the plots
to a PDF or to return the list of plots that you can then print using
\link[cowplot:plot_grid]{plot_grid}.}

\item{spatial}{A \code{logical(1)} indicating whether to include the histology
layer from \code{\link[=geom_spatial]{geom_spatial()}}. If you plan to use
\link[plotly:ggplotly]{ggplotly()} then it's best to set this to \code{FALSE}.}

\item{viridis}{A \code{logical(1)} whether to use the color-blind friendly
palette from \link[viridisLite:viridis]{viridis} or the color palette used
in the paper that was chosen for contrast when visualizing the data on
top of the histology image. One issue is being able to differentiate low
values from NA ones due to the purple-ish histology information that is
dependent on cell density.}

\item{height}{A \code{numeric(1)} passed to \link[grDevices:pdf]{pdf}.}

\item{width}{A \code{numeric(1)} passed to \link[grDevices:pdf]{pdf}.}

\item{image_id}{A \code{character(1)} with the name of the image ID you want to
use in the background.}

\item{alpha}{A \code{numeric(1)} in the \verb{[0, 1]} range that specifies the
transparency level of the data on the spots.}

\item{cont_colors}{A \code{character()} vector of colors that supersedes the
\code{viridis} argument.}

\item{sample_order}{A \code{character()} with the names of the samples to use
and their order.}

\item{point_size}{A \code{numeric(1)} specifying the size of the points. Defaults
to \code{1.25}. Some colors look better if you use \code{2} for instance.}

\item{auto_crop}{A \code{logical(1)} indicating whether to automatically crop
the image / plotting area, which is useful if the Visium capture area is
not centered on the image and if the image is not a square.}

\item{na_color}{A \code{character(1)} specifying a color for the NA values.
If you set \code{alpha = NA} then it's best to set \code{na_color} to a color that has
alpha blending already, which will make non-NA values pop up more and the NA
values will show with a lighter color. This behavior is lost when \code{alpha} is
set to a non-\code{NA} value.}

\item{is_stitched}{A \code{logical(1)} vector: If \code{TRUE}, expects a
\link[SpatialExperiment:SpatialExperiment]{SpatialExperiment-class} built
with \code{visiumStitched::build_spe()}.
\url{http://research.libd.org/visiumStitched/reference/build_spe.html}; in
particular, expects a logical colData column \code{exclude_overlapping}
specifying which spots to exclude from the plot. Sets \code{auto_crop = FALSE}.}

\item{cap_percentile}{A \code{numeric(1)} in (0, 1] determining the maximum
percentile (as a proportion) at which to cap expression. For example, a value
of 0.95 sets the top 5\% of expression values to the 95th percentile value.
This can help make the color scale more dynamic in the presence of high
outliers. Defaults to \code{1}, which effectively performs no capping.}

\item{...}{Passed to \link[base:paste]{paste0()} for making the title of the
plot following the \code{sampleid}.}
}
\value{
A list of \link[ggplot2:ggplot]{ggplot2} objects.
}
\description{
This function visualizes the gene expression stored in \code{assays(spe)} or any
continuous variable stored in \code{colData(spe)} for a set of samples at the
spot-level using (by default) the histology information on the background.
To visualize clusters (or any discrete variable) use \code{\link[=vis_grid_clus]{vis_grid_clus()}}.
}
\details{
This function prepares the data and then loops through
\code{\link[=vis_gene]{vis_gene()}} for computing the list of \link[ggplot2:ggplot]{ggplot2}
objects.
}
\examples{

if (enough_ram()) {
    ## Obtain the necessary data
    if (!exists("spe")) spe <- fetch_data("spe")

    ## Subset to two samples of interest and obtain the plot list
    p_list <-
        vis_grid_gene(
            spe[, spe$sample_id \%in\% c("151673", "151674")],
            spatial = FALSE,
            return_plots = TRUE
        )

    ## Visualize the spatial adjacent replicates for position = 0 micro meters
    ## for subject 3
    cowplot::plot_grid(plotlist = p_list, ncol = 2)
}
}
\seealso{
Other Spatial gene visualization functions: 
\code{\link{vis_gene}()},
\code{\link{vis_gene_p}()}
}
\concept{Spatial gene visualization functions}
