% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_grid_clus.R
\name{vis_grid_clus}
\alias{vis_grid_clus}
\title{Sample spatial cluster visualization grid}
\usage{
vis_grid_clus(
  spe,
  clustervar,
  pdf_file,
  sort_clust = TRUE,
  colors = NULL,
  return_plots = FALSE,
  spatial = TRUE,
  height = 24,
  width = 36,
  image_id = "lowres",
  alpha = NA,
  sample_order = unique(spe$sample_id),
  point_size = 2,
  auto_crop = TRUE,
  na_color = "#CCCCCC40",
  is_stitched = FALSE,
  guide_point_size = point_size,
  ...
)
}
\arguments{
\item{spe}{A
\link[SpatialExperiment:SpatialExperiment]{SpatialExperiment-class}
object. See \code{\link[=fetch_data]{fetch_data()}} for how to download some example objects or
\code{\link[=read10xVisiumWrapper]{read10xVisiumWrapper()}} to read in \code{spaceranger --count} output files and
build your own \code{spe} object.}

\item{clustervar}{A \code{character(1)} with the name of the \code{colData(spe)}
column that has the cluster values.}

\item{pdf_file}{A \code{character(1)} specifying the path for the resulting PDF.}

\item{sort_clust}{A \code{logical(1)} indicating whether you want to sort
the clusters by frequency using \code{\link[=sort_clusters]{sort_clusters()}}.}

\item{colors}{A vector of colors to use for visualizing the clusters
from \code{clustervar}. If the vector has names, then those should match the
values of \code{clustervar}.}

\item{return_plots}{A \code{logical(1)} indicating whether to print the plots
to a PDF or to return the list of plots that you can then print using
\link[cowplot:plot_grid]{plot_grid}.}

\item{spatial}{A \code{logical(1)} indicating whether to include the histology
layer from \code{\link[=geom_spatial]{geom_spatial()}}. If you plan to use
\link[plotly:ggplotly]{ggplotly()} then it's best to set this to \code{FALSE}.}

\item{height}{A \code{numeric(1)} passed to \link[grDevices:pdf]{pdf}.}

\item{width}{A \code{numeric(1)} passed to \link[grDevices:pdf]{pdf}.}

\item{image_id}{A \code{character(1)} with the name of the image ID you want to
use in the background.}

\item{alpha}{A \code{numeric(1)} in the \verb{[0, 1]} range that specifies the
transparency level of the data on the spots.}

\item{sample_order}{A \code{character()} with the names of the samples to use
and their order.}

\item{point_size}{A \code{numeric(1)} specifying the size of the points. Defaults
to \code{1.25}. Some colors look better if you use \code{2} for instance.}

\item{auto_crop}{A \code{logical(1)} indicating whether to automatically crop
the image / plotting area, which is useful if the Visium capture area is
not centered on the image and if the image is not a square.}

\item{na_color}{A \code{character(1)} specifying a color for the NA values.
If you set \code{alpha = NA} then it's best to set \code{na_color} to a color that has
alpha blending already, which will make non-NA values pop up more and the NA
values will show with a lighter color. This behavior is lost when \code{alpha} is
set to a non-\code{NA} value.}

\item{is_stitched}{A \code{logical(1)} vector: If \code{TRUE}, expects a
\link[SpatialExperiment:SpatialExperiment]{SpatialExperiment-class} built
with \code{visiumStitched::build_spe()}.
\url{http://research.libd.org/visiumStitched/reference/build_spe.html}; in
particular, expects a logical colData column \code{exclude_overlapping}
specifying which spots to exclude from the plot. Sets \code{auto_crop = FALSE}.}

\item{guide_point_size}{A \code{numeric(1)} specifying the size of the points in
guide. Defaults to \code{point_size}. Increase to improve visability.}

\item{...}{Passed to \link[base:paste]{paste0()} for making the title of the
plot following the \code{sampleid}.}
}
\value{
A list of \link[ggplot2:ggplot]{ggplot2} objects.
}
\description{
This function visualizes the clusters for a set of samples at the spot-level
using (by default) the histology information on the background. To visualize
gene-level (or any continuous variable) use \code{\link[=vis_grid_gene]{vis_grid_gene()}}.
}
\details{
This function prepares the data and then loops through
\code{\link[=vis_clus]{vis_clus()}} for computing the list of \link[ggplot2:ggplot]{ggplot2}
objects.
}
\examples{

if (enough_ram()) {
    ## Obtain the necessary data
    if (!exists("spe")) spe <- fetch_data("spe")

    ## Subset to two samples of interest and obtain the plot list
    p_list <-
        vis_grid_clus(
            spe[, spe$sample_id \%in\% c("151673", "151674")],
            "layer_guess_reordered",
            spatial = FALSE,
            return_plots = TRUE,
            sort_clust = FALSE,
            colors = libd_layer_colors
        )

    ## Visualize the spatial adjacent replicates for position = 0 micro meters
    ## for subject 3
    cowplot::plot_grid(plotlist = p_list, ncol = 2)
}
}
\seealso{
Other Spatial cluster visualization functions: 
\code{\link{frame_limits}()},
\code{\link{vis_clus}()},
\code{\link{vis_clus_p}()},
\code{\link{vis_image}()}
}
\concept{Spatial cluster visualization functions}
