% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi_gene_pca.R
\name{multi_gene_pca}
\alias{multi_gene_pca}
\title{Combine multiple continuous variables through PCA}
\usage{
multi_gene_pca(cont_mat)
}
\arguments{
\item{cont_mat}{A \code{matrix()} with spots as rows and 2 or more continuous
variables as columns.}
}
\value{
A \code{numeric()} vector with one element per spot, summarizing the
multiple continuous variables.
}
\description{
PCA is performed on \code{cont_mat}, the matrix of multiple continuous
features. The first PC is returned, representing the dominant spatial
signature of the feature set. Its direction is negated if necessary so that
the majority of coefficients across features are positive (when the features
are highly correlated, this encourages spots with higher values to
represent areas of higher expression of the features).
}
\seealso{
Other functions for summarizing expression of multiple continuous variables simultaneously: 
\code{\link{multi_gene_sparsity}()},
\code{\link{multi_gene_z_score}()}
}
\author{
Nicholas J. Eagles
}
\concept{functions for summarizing expression of multiple continuous variables simultaneously}
\keyword{internal}
