% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enough_ram.R
\name{enough_ram}
\alias{enough_ram}
\title{Determine if you have enough RAM memory}
\usage{
enough_ram(how_much = 4e+09)
}
\arguments{
\item{how_much}{The number of bytes you want to compare against.}
}
\value{
A \code{logical(1)} indicating whether your system has enough RAM memory.
}
\description{
This function determines if you have enough RAM memory on your system.
}
\details{
If \code{benchmarkme::get_ram()} fails, this function will return
\code{FALSE} as a save bet.
}
\examples{

## Do you have ~ 4 GB in your system?
enough_ram(4e9)

## Do you have ~ 100 GB in your system
enough_ram(100e9)
}
