% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_sce_layer.R
\name{check_sce_layer}
\alias{check_sce_layer}
\title{Check input sce_layer}
\usage{
check_sce_layer(sce_layer, variables = "spatialLIBD")
}
\arguments{
\item{sce_layer}{Defaults to the output of
\code{fetch_data(type = 'sce_layer')}. This is a
\linkS4class{SingleCellExperiment}
object with the spot-level Visium data compressed via pseudo-bulking to the
layer-level (group-level) resolution. See \code{\link[=fetch_data]{fetch_data()}} for more details.}

\item{variables}{A \code{character()} vector of variable names expected to
be present in \code{colData(sce_layer)}.}
}
\value{
The input object if all checks are passed.
}
\description{
This function checks that the \code{sce_layer} object has the appropriate structure.
For more details please check the vignette documentation.
}
\examples{

## Obtain example data from the HumanPilot project
## (Maynard, Collado-Torres, et al, 2021)
if (!exists("sce_layer")) sce_layer <- fetch_data("sce_layer")

## Check the pseudo-bulked data
check_sce_layer(sce_layer)
}
\seealso{
Other Check input functions: 
\code{\link{check_modeling_results}()},
\code{\link{check_sce}()},
\code{\link{check_spe}()}
}
\concept{Check input functions}
