library("here")
library("sessioninfo")


outdir <- "spatialLIBD_files"
pkgname <- "spatialLIBD"


meta <- data.frame(
    Title = c(
        "LFF_spatial_ERC_SRT",
        "LFF_spatial_ERC_SRT_pseudobulk",
        "LFF_spatial_ERC_SRT_modeling_results",
        "LFF_spatial_ERC_snRNAseq",
        "LFF_spatial_ERC_snRNAseq_pseudobulk_broad",
        "LFF_spatial_ERC_snRNAseq_pseudobulk_subcluster",
        "LFF_spatial_ERC_snRNAseq_modeling_results_broad",
        "LFF_spatial_ERC_snRNAseq_modeling_results_subcluster"
    ),
    Description = c(
        "SpatialExperiment object at the spot-level for the LFF_spatial_ERC human brain (ERC) spatial transcriptomics data (n = 31) from the Visium platform from 10x Genomics generated by the Lieber Institute for Brain Development (LIBD) and available through the spatialLIBD Bioconductor package.",
        "Pseudo-bulked SingleCellExperiment object (SpatialExperiment object without spatial data) at the Sp09D spatial domain resolution for the LFF_spatial_ERC human brain (ERC) spatial transcriptomics data (n = 31) from the Visium platform from 10x Genomics generated by the Lieber Institute for Brain Development (LIBD) and available through the spatialLIBD Bioconductor package.",
        "List of modeling results at the Sp09D spatial domain resolution for the LFF_spatial_ERC human brain (ERC) spatial transcriptomics data (n = 30) from the Visium platform from 10x Genomics generated by the Lieber Institute for Brain Development (LIBD) and available through the spatialLIBD Bioconductor package.",
        "SingleCellExperiment object for the LFF_spatial_ERC human brain (ERC) single nucleus transcriptomics data (snRNA-seq, n = 31) from the Chromium platform from 10x Genomics generated by the Lieber Institute for Brain Development (LIBD) and available through the spatialLIBD Bioconductor package.",
        "Pseudo-bulked SingleCellExperiment object LFF_spatial_ERC human brain (ERC) snRNA-seq data (n = 31) at 9 broad cell type resolution, from the Chromium platform from 10x Genomics generated by the Lieber Institute for Brain Development (LIBD) and available through the spatialLIBD Bioconductor package.",
        "Pseudo-bulked SingleCellExperiment object LFF_spatial_ERC human brain (ERC) snRNA-seq data (n = 31) at 38 subcluster resolution, from the Chromium platform from 10x Genomics generated by the Lieber Institute for Brain Development (LIBD) and available through the spatialLIBD Bioconductor package.",
        "List of modeling results at the 9 broad cell type resolution for the LFF_spatial_ERC human brain (ERC) for snRNA-seq (n = 31) from the Chromium platform from 10x Genomics generated by the Lieber Institute for Brain Development (LIBD) and available through the spatialLIBD Bioconductor package.",
        "List of modeling results at the 38 subcluster resolution for the LFF_spatial_ERC human brain (ERC) for snRNA-seq (n = 31) from the Chromium platform from 10x Genomics generated by the Lieber Institute for Brain Development (LIBD) and available through the spatialLIBD Bioconductor package."
    ),
    BiocVersion = "3.21",
    Genome = "GRCh38",
    SourceType = "GTF",
    SourceUrl = "https://bioconductor.org/packages/spatialLIBD",
    SourceVersion = "Nov 20 2025",
    Species = "Homo sapiens",
    TaxonomyId = 9606,
    Coordinate_1_based = TRUE,
    DataProvider = "LIBD",
    Maintainer = "Leonardo Collado-Torres <lcolladotor@gmail.com>",
    RDataClass = c(
        "SpatialExperiment",
        "SingleCellExperiment",
        "list",
        "SingleCellExperiment",
        "SingleCellExperiment",
        "SingleCellExperiment",
        "list",
        "list"
    ),
    DispatchClass = c(
        "FilePath",
        "Rds",
        "Rds",
        "FilePath",
        "Rds",
        "Rds",
        "Rds",
        "Rds"
    ),
    RDataPath = file.path(
        pkgname,
        outdir,
        c(
            "spe_ERC_annotated.zip",
            "spe_pseudobulk-SpD.rds",
            "modeling_results-SpD.rds",
            "sce_ERC_subcluster.zip",
            "sce_subcluster_pseudobulk-cell_type_broad.rds",
            "sce_subcluster_pseudobulk-cell_type_anno.rds",
            "sce_subcluster_pseudobulk-cell_type_broad.rds",
            "sce_subcluster_modeling_results-cell_type_anno.rds"
        )
    ),
    Tags = "Visium_snRNAseq_AD_Alzheimer_Disease_APOE_ERC_spatialLIBD",
    row.names = NULL,
    stringsAsFactors = FALSE
)

write.csv(
    meta,
    file = here::here("inst", "extdata", "metadata_LFF_spatial_ERC.csv"),
    row.names = FALSE
)

## Check
if (FALSE) {
    AnnotationHubData::makeAnnotationHubMetadata(
        here::here(),
        fileName = "metadata_LFF_spatial_ERC.csv"
    )
}

## Reproducibility information
print("Reproducibility information:")
Sys.time()
proc.time()
options(width = 120)
session_info()

# ─ Session info ───────────────────────────────────────────────────────────────────────────────────────────────────────
#  setting  value
#  version  R version 4.5.1 (2025-06-13)
#  os       macOS Sequoia 15.6.1
#  system   aarch64, darwin20
#  ui       RStudio
#  language (EN)
#  collate  en_US.UTF-8
#  ctype    en_US.UTF-8
#  tz       America/New_York
#  date     2026-01-09
#  rstudio  2026.01.0+392 Apple Blossom (desktop)
#  pandoc   3.7.0.2 @ /opt/homebrew/bin/ (via rmarkdown)
#  quarto   1.4.550 @ /usr/local/bin/quarto
#
# ─ Packages ───────────────────────────────────────────────────────────────────────────────────────────────────────────
#  package     * version    date (UTC) lib source
#  brio          1.1.5      2024-04-24 [1] CRAN (R 4.5.0)
#  cachem        1.1.0      2024-05-16 [1] CRAN (R 4.5.0)
#  cli           3.6.5      2025-04-23 [1] CRAN (R 4.5.0)
#  colorout    * 1.3-2      2025-05-09 [1] Github (jalvesaq/colorout@572ab10)
#  crayon        1.5.3      2024-06-20 [1] CRAN (R 4.5.0)
#  data.table    1.18.0     2025-12-24 [1] CRAN (R 4.5.2)
#  devtools    * 2.4.6      2025-10-03 [1] CRAN (R 4.5.0)
#  digest        0.6.39     2025-11-19 [1] CRAN (R 4.5.2)
#  ellipsis      0.3.2      2021-04-29 [1] CRAN (R 4.5.0)
#  evaluate      1.0.5      2025-08-27 [1] CRAN (R 4.5.0)
#  fastmap       1.2.0      2024-05-15 [1] CRAN (R 4.5.0)
#  fs            1.6.6      2025-04-12 [1] CRAN (R 4.5.0)
#  generics      0.1.4      2025-05-09 [1] CRAN (R 4.5.0)
#  glue          1.8.0      2024-09-30 [1] CRAN (R 4.5.0)
#  here        * 1.0.2      2025-09-15 [1] CRAN (R 4.5.0)
#  hms           1.1.4      2025-10-17 [1] CRAN (R 4.5.0)
#  htmltools     0.5.9      2025-12-04 [1] CRAN (R 4.5.2)
#  knitr         1.51       2025-12-20 [1] CRAN (R 4.5.2)
#  lifecycle     1.0.4      2023-11-07 [1] CRAN (R 4.5.0)
#  lubridate     1.9.4      2024-12-08 [1] CRAN (R 4.5.0)
#  magrittr      2.0.4      2025-09-12 [1] CRAN (R 4.5.0)
#  memoise       2.0.1      2021-11-26 [1] CRAN (R 4.5.0)
#  otel          0.2.0      2025-08-29 [1] CRAN (R 4.5.0)
#  pkgbuild      1.4.8      2025-05-26 [1] CRAN (R 4.5.0)
#  pkgconfig     2.0.3      2019-09-22 [1] CRAN (R 4.5.0)
#  pkgload       1.4.1      2025-09-23 [1] CRAN (R 4.5.0)
#  prompt        1.0.2.9000 2024-12-10 [1] Github (gaborcsardi/prompt@17bd0e1)
#  purrr         1.2.0      2025-11-04 [1] CRAN (R 4.5.0)
#  R6            2.6.1      2025-02-15 [1] CRAN (R 4.5.0)
#  remotes       2.5.0      2024-03-17 [1] CRAN (R 4.5.0)
#  rlang         1.1.6      2025-04-11 [1] CRAN (R 4.5.0)
#  rmarkdown     2.30       2025-09-28 [1] CRAN (R 4.5.0)
#  rprojroot     2.1.1      2025-08-26 [1] CRAN (R 4.5.0)
#  rsconnect     1.7.0      2025-12-06 [1] CRAN (R 4.5.2)
#  rsthemes      0.5.0      2025-05-09 [1] Github (gadenbuie/rsthemes@96fb91a)
#  rstudioapi    0.17.1     2024-10-22 [1] CRAN (R 4.5.0)
#  sessioninfo * 1.2.3      2025-02-05 [1] CRAN (R 4.5.0)
#  suncalc       0.5.1      2022-09-29 [1] CRAN (R 4.5.0)
#  testthat    * 3.3.1      2025-11-25 [1] CRAN (R 4.5.2)
#  timechange    0.3.0      2024-01-18 [1] CRAN (R 4.5.0)
#  usethis     * 3.2.1      2025-09-06 [1] CRAN (R 4.5.0)
#  vctrs         0.6.5      2023-12-01 [1] CRAN (R 4.5.0)
#  xfun          0.55       2025-12-16 [1] CRAN (R 4.5.2)
#  yaml          2.3.12     2025-12-10 [1] CRAN (R 4.5.2)
#
#  [1] /Library/Frameworks/R.framework/Versions/4.5-arm64/Resources/library
#  * ── Packages attached to the search path.
#
# ──────────────────────────────────────────────────────────────────────────────────────────────────────────────────────
