% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/williams2020_tmt.R
\docType{data}
\name{williams2020_tmt}
\alias{williams2020_tmt}
\title{Williams et al. 2020 (Anal. Chem.): 3 AML cell line}
\format{
A \link{QFeatures} object with 4 assays, each assay being a
\link{SingleCellExperiment} object:
\itemize{
\item \verb{peptides_[intensity or corrected]}: 2 assays containing peptide
reporter ion intensities or corrected reporter ion intensities
as computed by MaxQuant.
\item \verb{proteins_[intensity or corrected]}: 2 assays containing protein
reporter ion intensities or corrected reporter ion intensities
as computed by MaxQuant.
}

Sample annotation is stored in \code{colData(williams2020_tmt())}.
}
\source{
The PSM and protein data can be downloaded from the MASSIVE
repository MSV000085230.
}
\usage{
williams2020_tmt
}
\description{
Single-cell label data from three acute myeloid
leukemia cell line culture (MOLM-14, K562, CMK). The data were
acquired using a TMT-based quantification protocole and the
nanoPOTS technology. The objective was to demonstrate successful
use of the new nanoPOTS autosampler presented in the source
article. The samples contain either carrier (10 ng), reference
(0.2ng), empty or single-cell samples..
}
\section{Acquisition protocol}{


The data were acquired using the following setup. More information
can be found in the source article (see \code{References}).
\itemize{
\item \strong{Sample isolation}: cultured MOLM-14, K562 or CMK cells were
isolated using flow-cytometry based cell sorting and deposit on
nanoPOTS microwells
\item \strong{Sample preparation}: cells are lysed using using a DDM lysis
buffer. Proteins are digested with trypsin followed by TMT
labelling and quanching with HA. The samples are then acidified
with FA, pooled in a single samples (adding carrier and reference
peptide mixtures), and dried until LC-MS/MS analysis.
\item \strong{Liquid chromatography}: peptides are loaded using the new
autosampler described in the paper. Samples are loaded using a
a homemade miniature syringe pump. The samples are then desalted
and concentrated through a SPE column (4cm x 100µm i.d. packed
with 5µm C18) with microflow LC pump. The peptides are then eluted
from a long LC column (60cm x 50 µm i.d. packed with 3µm C18)
coupled to a nanoflox LC pump at 150nL/mL (elution time is not
expliceted).
\item \strong{Mass spectrometry}: MS/MS was performed on an Orbitrap Fusion
Lumos Tribrid MS coupled to a 2kV ESI. MS1 setup: Orbitrap
analyzer at resolution 120.000, AGC target of 1E6, accumulation
of 246ms. MS2 setup: Orbitrap with HCD at resolution 120.000, AGC
target of 1E6, accumulation of 246ms.
\item \strong{Raw data processing}: preprocessing using Maxquant v1.6.2.10
that use Andromeda search engine (with UniProtKB 2016-21-29).
}
}

\section{Data collection}{


All data were collected from the MASSIVE repository (accession ID:
MSV000085230).

The peptide and protein data were extracted from the
\code{Peptides_AML_SingleCell.txt} or \code{ProteinGroups_AML_SingleCell.txt}
files, respectively, in the \code{AML_SingleCell} folders.

The tables were duplicated so that intensisities and corrected
intensities are contained in separate tables. Tables are then
converted to \link{SingleCellExperiment} objects. Sample annotations
were inferred from the sample names, from table S2 and from the
Experimental Section of the paper. All data is combined in
a \link{QFeatures} object. \link{AssayLinks} were stored between peptide
assays and their corresponding proteins assays based on the
leading razor protein (hence only unique peptides are linked to
proteins).

The script to reproduce the \code{QFeatures} object is available at
\code{system.file("scripts", "make-data_williams2020_tmt.R", package = "scpdata")}
}

\examples{
\donttest{
williams2020_tmt()
}

}
\references{
\strong{Source article}: Williams, Sarah M., Andrey V. Liyu, Chia-Feng
Tsai, Ronald J. Moore, Daniel J. Orton, William B. Chrisler,
Matthew J. Gaffrey, et al. 2020. “Automated Coupling of
Nanodroplet Sample Preparation with Liquid Chromatography-Mass
Spectrometry for High-Throughput Single-Cell Proteomics.”
Analytical Chemistry 92 (15): 10588–96.
(\href{http://dx.doi.org/10.1021/acs.analchem.0c01551}{link to article}).
}
\keyword{datasets}
