% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guise2024.R
\docType{data}
\name{guise2024}
\alias{guise2024}
\title{Guise et al. 2020 (Cell Rep.): postmortem ALS spinal moto neurons}
\format{
A \link{QFeatures} object with 102 assays, each assay being a
\link{SingleCellExperiment} object:
\itemize{
\item \verb{F*}: 100 assays containing PSM data.
\item \code{peptides}: quantitative data for 34,315 peptides in 108 samples.
All samples combined, along with 8 additional unannotated
samples.
\item \code{proteins}: quantitative data for 4,437 protein groups in 108
samples. All samples combined, along with 8 additional
unannotated samples.
}

Sample annotation is stored in \code{colData(guise2024())}.
}
\source{
All data can be downloaded from the MassIVE repository
MSV000092119. The source link is:
ftp://massive.ucsd.edu/v05/MSV000092119/
}
\usage{
guise2024
}
\description{
Single-cell proteomics data from postmortem human spinal moto
neurons (MN) obtained from control donors or donors with amyotrophic
lateral sclerosis (ALS). The data were generated following the
NanoPOTS protocol. Cells were isolated from samples obtained by
the university of Miami Brain Bank using laser capture
microdissection (LCM). Additional information about the amount of
TDP-43 intra-cellular levels has been assigned into levels 0 to 4.
}
\section{Acquisition protocol}{


The data were acquired using the following setup. More information
can be found in the source article (see \code{References}).
\itemize{
\item \strong{Cell isolation}: The MN were isolated from samples obtained
by the university of Miami Brain Bank using LCM.
\item \strong{Sample preparation} performed using the nanoPOTS workflow.
Cells are treated with 0.1\% DDM (for lysis) added with DTT
(protein reduction), then IAA (alkylation), then Lys-C and
trypsin (protein digestion).
\item \strong{Separation}: Samples were injected on the column using an
Ultimate 3000 RSLCnano pump. The in-line loading column is a
home-packed SPE column (5cm x 75um) while the peptide
separation is performed on a an in-house-packed analytical SPE
column (50 cm x 30um), using a 20nL/min flow rate.
\item \strong{Ionization}: nanospray emmitter (2,000V)
\item \strong{Mass spectrometry}: Orbitrap Exploris 480. HCD fragmentation.
MS1 settings: accumulation time = 200 ms; resolution = 120,000;
AGC = 1E6. MS2 settings: exclusion duration = 90 s;
accumulation time = 500 ms; resolution = 30,000; AGC = 1E5.
\item \strong{Data analysis}: Sequest HT in Proteome Discoverer (v2.5) and
the search database is Swiss-Prot (July 2020).
}
}

\section{Data collection}{


All data were collected from the MassIVE repository (accession ID:
MSV000092119).

The sample annotations were combined from the tables in
\verb{Biogen_TDP43_Round2_Reanalysis_10-13-2021_InputFiles.txt} and in
\code{Groups.txt}.

The PSM data were found in the
\verb{Biogen_TDP43_Round2_Reanalysis_10-13-2021_PSMs.txt} file. The
data were converted to a \link{QFeatures} object using the \code{\link[scp:readSCP]{scp::readSCP()}}
function. We could not find sample annotations for MS run ID:
F61, F34, F42, F88, F77, F8, F21, F5.

The peptide data were found in the
\verb{Biogen_TDP43_Round2_Reanalysis_10-13-2021_PeptideGroups.txt}
file. The column names holding the quantitative data were adapted
to match the sample names in the \link{QFeatures} object. The data were
then converted to a \link{SingleCellExperiment} object and then
inserted in the \link{QFeatures} object.

A similar procedure was applied to the protein data. The data were
found in the
\verb{Biogen_TDP43_Round2_Reanalysis_10-13-2021_Proteins.txt} file. The
column names were
adapted, the data were converted to a \link{SingleCellExperiment}
object and then inserted in the \link{QFeatures} object.
}

\examples{
\donttest{
guise2024()
}

}
\references{
Guise, Amanda J., Santosh A. Misal, Richard Carson, Jen-Hwa Chu,
Hannah Boekweg, Daisha Van Der Watt, Nora C. Welsh, et al. 2024.
“TDP-43-Stratified Single-Cell Proteomics of Postmortem Human
Spinal Motor Neurons Reveals Protein Dynamics in Amyotrophic
Lateral Sclerosis.” Cell Reports 43 (1): 113636.
(\href{http://dx.doi.org/10.1016/j.celrep.2023.113636}{link to article}).
}
\keyword{datasets}
