\docType{data}
\name{rogers1000.data}
\alias{rogers1000.data}
\title{Simulated Gene Expression Data}
\description{
    Dataset containing 1000 samples and 1000 genes generated by the publicly 
    available generator using a power-law tail topology network  with no 
    added noise.
}
\usage{data(rogers1000.data)}
\format{
    \code{rogers1000.data} is a data frame containing 1000 rows and 
    1000 columns. Each row contains a simulated microarray experiment 
    and each column contains a gene.
}
\source{
    sRogers with Power-law tail topology 
}
\references{
    Rogers, Simon, and Mark Girolami. "A Bayesian regression approach 
    to the inference of regulatory networks from gene expression data." 
    Bioinformatics 21.14 (2005): 3131-3137.
}
\value{
    \code{data.frame} containg the data.
}
\seealso{
    \code{\link{rogers1000.net}}, \code{\link{gnw1565.data}}, 
    \code{\link{gnw2000.data}}, \code{\link{syntren300.data}}, 
    \code{\link{syntren1000.data}}
}
\examples{
    data(rogers1000.data)
    # Print size
    print(dim(rogers1000.data))
}
\keyword{datasets}
