% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bugphyzz.R
\name{getTaxonSignatures}
\alias{getTaxonSignatures}
\title{Get Taxon Signatures}
\usage{
getTaxonSignatures(tax, bp, ...)
}
\arguments{
\item{tax}{A valid NCBI ID or taxon name. If taxon name is used, the
argument taxIdType = "Taxon_name" must also be used.}

\item{bp}{List of data.frames imported with \code{importBugphyzz}.}

\item{...}{Arguments passed to \code{makeSignatures}.}
}
\value{
A character vector with the names of the signatures for a taxon.
}
\description{
\code{getTaxonSignatures} returns the names of all of the signatures
associated with a particular taxon. More details can be found in the main
bugphyzz vignette; please run \code{browseVignettes("bugphyzz")}.
}
\examples{
taxid <- "562"
taxonName <- "Escherichia coli"
bp <- importBugphyzz()
sig_names_1 <- getTaxonSignatures(taxid, bp)
sig_names_2 <- getTaxonSignatures(taxonName, bp, taxIdType = "Taxon_name")

}
