% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{exampleTENETMultiAssayExperiment}
\alias{exampleTENETMultiAssayExperiment}
\title{Example TENET MultiAssayExperiment object}
\usage{
exampleTENETMultiAssayExperiment(metadata = FALSE)
}
\arguments{
\item{metadata}{If TRUE, retrieve the ExperimentHub metadata instead of the
object itself. Defaults to FALSE.}
}
\value{
A MultiAssayExperiment object composed of "expression" and
"methylation" SummarizedExperiment objects, clinical information about
the patients in the colData, and information about sample pairing and
type ('Case' vs. 'Control') in the sampleMap.
}
\description{
A MultiAssayExperiment dataset created using a modified version
of the \code{TCGADownloader} function from the TENET package utilizing
TCGAbiolinks package functionality. This object contains two
SummarizedExperiment objects, \code{expression} and \code{methylation}, with
expression data for 11,637 genes annotated to the GENCODE v36 dataset,
including all 1,637 identified human TF genes, and DNA methylation data for
20,000 probes from the Illumina HM450 methylation array. The data are
aligned to the human hg38 genome. Expression and methylation values were
matched from 200 tumor and 42 adjacent normal tissue samples subset from the
TCGA BRCA dataset. Additionally, results from running the TENET step 1-6
functions on these samples are included in the metadata of this
MultiAssayExperiment object. Clinical data for these samples are included in
the colData of the MultiAssayExperiment object. (A separate data frame
object containing a subset of the clinical data for these samples is
available as \code{exampleTENETClinicalDataFrame}.) This dataset is included to
demonstrate TENET functions. Note: Because this dataset is a small subset of
the overall BRCA dataset, results generated by TENET from this dataset
differ from those presented for the BRCA dataset at large in TENET
publications.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
exampleTENETMultiAssayExperiment()
\dontshow{\}) # examplesIf}
}
