/*
 * Decompiled with CFR 0.152.
 */
package slib.sml.sm.core.metrics.ic.topo;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.URI;
import slib.sml.sm.core.engine.SM_Engine;
import slib.sml.sm.core.metrics.ic.topo.ICtopo;
import slib.sml.sm.core.metrics.ic.utils.IC_Conf_Topo;
import slib.sml.sm.core.metrics.utils.LogBasedMetric;
import slib.sml.sm.core.utils.MathSML;
import slib.utils.ex.SLIB_Ex_Critic;

public class ICi_zhou_2008
extends LogBasedMetric
implements ICtopo {
    double k = 0.5;

    public ICi_zhou_2008() {
    }

    public ICi_zhou_2008(double k) {
        this.k = k;
    }

    public Map<URI, Double> compute(Map<URI, Integer> alldepths, Map<URI, Set<URI>> allDescendantsIncs) throws SLIB_Ex_Critic {
        HashMap<URI, Double> results = new HashMap<URI, Double>();
        double max_depth = Collections.max(alldepths.values()) + 1;
        int nbConcepts = alldepths.size();
        for (URI v : alldepths.keySet()) {
            int depth = alldepths.get(v);
            int nbHypo = allDescendantsIncs.get(v).size();
            double x = this.k * (1.0 - MathSML.log(nbHypo, this.getLogBase()) / MathSML.log(nbConcepts, this.getLogBase()));
            double y = (1.0 - this.k) * (MathSML.log((double)depth + 1.0, this.getLogBase()) / MathSML.log(max_depth, this.getLogBase()));
            double cur_ic = x + y;
            results.put(v, cur_ic);
        }
        return results;
    }

    @Override
    public Map<URI, Double> compute(IC_Conf_Topo conf, SM_Engine manager) throws SLIB_Ex_Critic {
        this.setLogBase(conf);
        if (conf.containsParam("k")) {
            this.k = Double.parseDouble((String)conf.getParam("k"));
        }
        return this.compute(manager.getMaxDepths(), manager.getAllDescendantsInc());
    }
}

