/*
 * Decompiled with CFR 0.152.
 */
package slib.sml.sm.core.measures.graph.pairwise.dag.edge_based;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.openrdf.model.URI;
import slib.sml.sm.core.engine.SM_Engine;
import slib.sml.sm.core.measures.graph.pairwise.dag.edge_based.Sim_DAG_edge_abstract;
import slib.sml.sm.core.measures.graph.pairwise.dag.edge_based.utils.SimDagEdgeUtils;
import slib.sml.sm.core.utils.SMconf;
import slib.utils.ex.SLIB_Exception;
import slib.utils.impl.SetUtils;

public class Sim_pairwise_DAG_edge_Stojanovic_2001
extends Sim_DAG_edge_abstract {
    @Override
    public double compare(URI a, URI b, SM_Engine c, SMconf conf) throws SLIB_Exception {
        Set<URI> ancestors_A = c.getAncestorsInc(a);
        Set<URI> ancestors_B = c.getAncestorsInc(b);
        Map<URI, Integer> maxDepths = c.getMaxDepths();
        return this.sim(a, b, ancestors_A, ancestors_B, maxDepths);
    }

    public double sim(URI cA, URI cB, Collection<URI> ancestors_A, Collection<URI> ancestors_B, Map<URI, Integer> maxDepths) throws SLIB_Exception {
        double sim = 0.0;
        Set<URI> interSecAncestors = SetUtils.intersection(ancestors_A, ancestors_B);
        if (!interSecAncestors.isEmpty()) {
            URI msa = SimDagEdgeUtils.searchMSA(interSecAncestors, maxDepths);
            int d_mrca = maxDepths.get(msa) + 1;
            int d_a = maxDepths.get(cA) + 1;
            int d_b = maxDepths.get(cB) + 1;
            double sto = (double)d_mrca / (double)(d_a + d_b - d_mrca);
            return sto;
        }
        return sim;
    }

    @Override
    public Boolean isSymmetric() {
        return true;
    }
}

