% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compose.R
\name{getFC}
\alias{getFC}
\title{Read FlyCodes (FCs)}
\source{
\itemize{
\item{\url{https://fgcz-gstore.uzh.ch/projects/p1644/analysis_20170609_o3040/p1644o3482-4_S4.extendedFrags_uniqNB2FC.txt}}
\item{\url{https://fgcz-gstore.uzh.ch/projects/p1644/analysis_20170609_o3040/p1644o3482-5_S5.extendedFrags_uniqNB2FC.txt}}
}
}
\usage{
getFC(pattern = "^GS[ASTNQDEFVLYWGP]{7}(WR|WLTVR|WQEGGR|WLR|WQSR)$",
  filename = NULL)
}
\arguments{
\item{pattern}{a regular expression FlyCode pattern}

\item{filename}{a two column tab separated file containing a peptide
sequence and an ESP value. default is NULL which reads the data provided
by the package through ExperimentHub.}
}
\value{
a \code{data.frame} object of Flycodes
}
\description{
A wrapper function for reading the
flycodes using ExperimentHub.
The files are used for demonstrating the detectability of the AA
sequences. The wrapper functions are extended by columns
\code{\link[protViz]{ssrc}} prediction
and the \code{\link[protViz]{parentIonMass}}.
The column ESP_Prediction was generated by using the service from
\url{https://genepattern.broadinstitute.org}.
}
\examples{
FC <- getFC()
dim(FC)

}
\author{
Christian Panse <cp@fgcz.ethz.ch> 2015, 2018
}
