% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metascope_blast.R
\name{blastn_single_result}
\alias{blastn_single_result}
\title{blastn_single_result}
\usage{
blastn_single_result(
  results_table,
  bam_file,
  which_result,
  num_reads = 100,
  hit_list = 10,
  num_threads,
  db_path,
  quiet,
  accession_path,
  bam_seqs,
  out_path,
  sample_name,
  fasta_dir = NULL
)
}
\arguments{
\item{results_table}{A dataframe of the Metascope results}

\item{bam_file}{A sorted bam file and index file, loaded with
Rsamtools::bamFile}

\item{which_result}{Index in results_table for which result to Blast search}

\item{num_reads}{Number of reads to blast per result}

\item{hit_list}{Number of how many blast results to fetch per read}

\item{num_threads}{Number of threads if multithreading}

\item{db_path}{Blast database path}

\item{quiet}{Logical, whether to print out more informative messages. Default
is FALSE.}

\item{accession_path}{(character) Filepath to NCBI accessions SQL
database. See \code{taxonomzr::prepareDatabase()}.}

\item{bam_seqs}{A list of the sequence IDs from the bam file}

\item{out_path}{Path to output results.}

\item{sample_name}{Character string, sample name for output files.}

\item{fasta_dir}{Path to where fasta files are stored.}
}
\value{
Returns a dataframe of blast results for a metascope result
}
\description{
blastn_single_result
}
