% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metascope_blast.R
\name{blast_reassignment}
\alias{blast_reassignment}
\title{Reassign reads from MetaScope BLASTn alignment}
\usage{
blast_reassignment(
  metascope_blast_path,
  species_threshold,
  num_hits,
  blast_tmp_dir,
  out_dir,
  sample_name,
  reassign_validated = FALSE,
  reassign_to_validated = TRUE
)
}
\arguments{
\item{metascope_blast_path}{Character string. The filepath to a
\code{metascope_blast} CSV output file.}

\item{species_threshold}{Numeric. A number between 0 and 1 indicating
the minimum proportion of reads needed for a taxon to be considered
validated from the BLAST results. Default is 0.2, or 20\%.}

\item{num_hits}{Integer. The number of hits for which to assess validation.
Default is 10, i.e., only the top 10 taxa will be assessed.}

\item{blast_tmp_dir}{Character string. Filepath of the directory where
BLAST results were output from the \code{metascope_blast} function.
Referencing the arguments from \code{metascope_blast}, this would be
\code{file.path(tmp_dir, "blast")}}

\item{out_dir}{Character string, path to output directory.}

\item{sample_name}{Character string, sample name for output files.}

\item{reassign_validated}{Logical. Should reads from validated accessions be
reassigned to other validated accessions. Defaults to \code{FALSE}}

\item{reassign_to_validated}{Logical. Should reads only be re-assigned to
validated accessions or to any accession with more reads than the current
accession. Defaults to \code{TRUE}}
}
\value{
Returns a \code{data.frame} with the reassigned taxa and read counts.
}
\description{
Using the output from \code{metascope_blast()}, the
\code{blast_reassignment()} function takes the results and alters the
original \code{metascope_id()} output to reassign reads that were invalidated
by the BLAST findings. Currently, the implementation of this function only
reassigns reads to a taxon that was already found in the sample at a higher
abundance.
}
