% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\name{MCF7_TNF}
\alias{MCF7_TNF}
\title{EMTscoreData: Single-cell RNA-seq datasets for EMTscore}
\format{
SingleCellExperiment object containing scRNA-seq profiles for
cell line and treatment.
}
\value{
SingleCellExperiment dataset
}
\description{
The EMTscoreData package provides 12 single-cell RNA-seq datasets from
Cook DP, Vanderhyden BC (2020). Context specificity of the EMT
transcriptional response. Nature Communications 11(1):2142.
}
\details{
These datasets profile epithelial-mesenchymal transition (EMT) in
human cancer cell lines MCF7 treated with TNF

Each dataset was processed into a SingleCellExperiment object and saved as
an .rda file.


The datasets can be accessed via \code{ExperimentHub} using the provided
accessors. Each object contains gene expression matrices and associated
cell metadata, such as treatment.
}
\examples{
library(ExperimentHub)
eh <- ExperimentHub()
query(eh, "EMTscoreData") 

#Example: load MCF7 TNF dataset
MCF7_TNF <- eh[["EH10282"]]

}
\references{
Cook DP, Vanderhyden BC. Context specificity of the EMT transcriptional
response. \emph{Nature Communications} 2020 May 1;11(1):2142.
}
