% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz.R
\name{DU145_TNF}
\alias{DU145_TNF}
\title{EMTscoreData: Single-cell RNA-seq datasets for EMTscore}
\format{
SingleCellExperiment object containing scRNA-seq profiles for
cell line and treatment.
}
\value{
SingleCellExperiment dataset
}
\description{
The EMTscoreData package provides 12 single-cell RNA-seq datasets from
Cook DP, Vanderhyden BC (2020). Context specificity of the EMT
transcriptional response. Nature Communications 11(1):2142.
}
\details{
These datasets profile epithelial-mesenchymal transition (EMT) in
human cancer cell lines DU145 treated with TNF

Each dataset was processed into a SingleCellExperiment object and saved as
an .rda file.


The datasets can be accessed via \code{ExperimentHub} using the provided
accessors. Each object contains gene expression matrices and associated
cell metadata, such as treatment.
}
\examples{
library(ExperimentHub)
eh <- ExperimentHub()
query(eh, "EMTscoreData") 

#Example: load DU145 TNF dataset
DU145_TNF <- eh[["EH10288"]]

}
\references{
Cook DP, Vanderhyden BC. Context specificity of the EMT transcriptional
response. \emph{Nature Communications} 2020 May 1;11(1):2142.
}
