
\name{ygs98_dbconn}

\alias{ygs98_dbconn}
\alias{ygs98_dbfile}
\alias{ygs98_dbschema}
\alias{ygs98_dbInfo}


\title{Collect information about the package annotation DB}

\description{
  Some convenience functions for getting a connection object to (or collecting
  information about) the package annotation DB.
}

\usage{
  ygs98_dbconn()
  ygs98_dbfile()
  ygs98_dbschema(file="", show.indices=FALSE)
  ygs98_dbInfo()
}

\arguments{
  \item{file}{
    A connection, or a character string naming the file to print to (see
    the \code{file} argument of the \code{\link[base]{cat}} function for
    the details).
  }
  \item{show.indices}{
    The CREATE INDEX statements are not shown by default.
    Use \code{show.indices=TRUE} to get them.
  }
}

\details{
  \code{ygs98_dbconn} returns a connection object to the
  package annotation DB.  IMPORTANT: Don't call
  \code{\link[DBI:dbConnect]{dbDisconnect}} on the connection object
  returned by \code{ygs98_dbconn} or you will break all the
  \code{\link[AnnotationDbi:AnnDbObj-class]{AnnDbObj}} objects defined
  in this package!

  \code{ygs98_dbfile} returns the path (character string) to the
  package annotation DB (this is an SQLite file).

  \code{ygs98_dbschema} prints the schema definition of the
  package annotation DB.

  \code{ygs98_dbInfo} prints other information about the package
  annotation DB.
}

\value{
  \code{ygs98_dbconn}: a DBIConnection object representing an
  open connection to the package annotation DB.

  \code{ygs98_dbfile}: a character string with the path to the
  package annotation DB.

  \code{ygs98_dbschema}: none (invisible \code{NULL}).

  \code{ygs98_dbInfo}: none (invisible \code{NULL}).
}

\seealso{
  \code{\link[DBI:dbSendQuery]{dbGetQuery}},
  \code{\link[DBI:dbConnect]{dbConnect}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbconn}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbfile}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbschema}},
  \code{\link[AnnotationDbi:AnnDbObj-class]{dbInfo}}
}

\examples{
  library(DBI)
  ## Count the number of rows in the "probes" table:
  dbGetQuery(ygs98_dbconn(), "SELECT COUNT(*) FROM probes")

  ygs98_dbschema()

  ygs98_dbInfo()
}

\keyword{utilities}
\keyword{datasets}

