datacache <- new.env(hash=TRUE, parent=emptyenv())

ygs98 <- function() showQCData("ygs98", datacache)
ygs98_dbconn <- function() dbconn(datacache)
ygs98_dbfile <- function() dbfile(datacache)
ygs98_dbschema <- function(file="", show.indices=FALSE) dbschema(datacache, file=file, show.indices=show.indices)
ygs98_dbInfo <- function() dbInfo(datacache)

ygs98ORGANISM <- "Saccharomyces cerevisiae"

.onLoad <- function(libname, pkgname)
{
    ## Connect to the SQLite DB
    dbfile <- system.file("extdata", "ygs98.sqlite", package=pkgname, lib.loc=libname)
    assign("dbfile", dbfile, envir=datacache)
    dbconn <- dbFileConnect(dbfile)
    assign("dbconn", dbconn, envir=datacache)

    ## Create the OrgDb object
    sPkgname <- sub(".db$","",pkgname)
    txdb <- loadDb(system.file("extdata", paste(sPkgname,
      ".sqlite",sep=""), package=pkgname, lib.loc=libname),
                   packageName=pkgname)    
    dbNewname <- AnnotationDbi:::dbObjectName(pkgname,"ChipDb")
    ns <- asNamespace(pkgname)
    assign(dbNewname, txdb, envir=ns)
    namespaceExport(ns, dbNewname)
        
    ## Create the AnnObj instances
    ann_objs <- createAnnObjs.SchemaChoice("YEASTCHIP_DB", "ygs98", "chip ygs98", dbconn, datacache)
    mergeToNamespaceAndExport(ann_objs, pkgname)
    packageStartupMessage(AnnotationDbi:::annoStartupMessages("ygs98.db"))
}

.onUnload <- function(libpath)
{
    dbFileDisconnect(ygs98_dbconn())
}

